/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafkaesque.common.message.CreateDelegationTokenResponseData;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractResponse;
import org.apache.kafkaesque.common.security.auth.KafkaPrincipal;

public class CreateDelegationTokenResponse
extends AbstractResponse {
    private final CreateDelegationTokenResponseData data;

    public CreateDelegationTokenResponse(CreateDelegationTokenResponseData data) {
        this.data = data;
    }

    public CreateDelegationTokenResponse(Struct struct, short version) {
        this.data = new CreateDelegationTokenResponseData(struct, version);
    }

    public static CreateDelegationTokenResponse parse(ByteBuffer buffer, short version) {
        return new CreateDelegationTokenResponse(ApiKeys.CREATE_DELEGATION_TOKEN.responseSchema(version).read(buffer), version);
    }

    public static CreateDelegationTokenResponse prepareResponse(int throttleTimeMs, Errors error, KafkaPrincipal owner, long issueTimestamp, long expiryTimestamp, long maxTimestamp, String tokenId, ByteBuffer hmac) {
        CreateDelegationTokenResponseData data = new CreateDelegationTokenResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setPrincipalType(owner.getPrincipalType()).setPrincipalName(owner.getName()).setIssueTimestampMs(issueTimestamp).setExpiryTimestampMs(expiryTimestamp).setMaxTimestampMs(maxTimestamp).setTokenId(tokenId).setHmac(hmac.array());
        return new CreateDelegationTokenResponse(data);
    }

    public static CreateDelegationTokenResponse prepareResponse(int throttleTimeMs, Errors error, KafkaPrincipal owner) {
        return CreateDelegationTokenResponse.prepareResponse(throttleTimeMs, error, owner, -1L, -1L, -1L, "", ByteBuffer.wrap(new byte[0]));
    }

    public CreateDelegationTokenResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(this.error(), 1);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

