/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.registry.impl.ServiceInstanceBase;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hive.com.google.common.base.Preconditions;

public class HiveServer2Instance
extends ServiceInstanceBase {
    private boolean isLeader;
    private String transportMode;
    private String httpEndpoint;

    public HiveServer2Instance() {
    }

    public HiveServer2Instance(ServiceRecord srv, String endPointName) throws IOException {
        super(srv, endPointName);
        Endpoint activeEndpoint = srv.getInternalEndpoint("activeEndpoint");
        Endpoint passiveEndpoint = srv.getInternalEndpoint("passiveEndpoint");
        this.isLeader = activeEndpoint != null;
        Preconditions.checkArgument(activeEndpoint == null || passiveEndpoint == null, "Incorrect service record. Both active and passive endpoints cannot be non-null!");
        this.transportMode = srv.get(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname);
        this.httpEndpoint = this.transportMode.equalsIgnoreCase("http") ? srv.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH.varname) : "";
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public String getTransportMode() {
        return this.transportMode;
    }

    public String getHttpEndpoint() {
        return this.httpEndpoint;
    }

    public void setLeader(boolean leader) {
        this.isLeader = leader;
    }

    public void setTransportMode(String transportMode) {
        this.transportMode = transportMode;
    }

    public void setHttpEndpoint(String httpEndpoint) {
        this.httpEndpoint = httpEndpoint;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveServer2Instance other = (HiveServer2Instance)o;
        return super.equals(o) && this.isLeader == other.isLeader && Objects.equals(this.transportMode, other.transportMode) && Objects.equals(this.httpEndpoint, other.httpEndpoint);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.isLeader) + Objects.hashCode(this.transportMode) + Objects.hashCode(this.httpEndpoint);
    }

    @Override
    public String toString() {
        String result = "instanceId: " + this.getWorkerIdentity() + " isLeader: " + this.isLeader + " host: " + this.getHost() + " port: " + this.getRpcPort() + " transportMode: " + this.transportMode;
        if (this.httpEndpoint != null) {
            result = result + " httpEndpoint: " + this.httpEndpoint;
        }
        return result;
    }
}

