/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.io.IOException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.service.auth.LdapAuthenticationProviderImpl;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.DirSearchFactory;
import org.apache.hive.service.auth.ldap.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KerberosLdapFilterEnforcer {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosLdapFilterEnforcer.class);
    private final HiveConf conf;
    private final DirSearchFactory dirSearchFactory;
    private final boolean enableLdapGroupCheck;
    private final Filter filter;

    public KerberosLdapFilterEnforcer(HiveConf conf, DirSearchFactory dirSearchFactory) {
        this.conf = conf;
        this.dirSearchFactory = dirSearchFactory;
        this.enableLdapGroupCheck = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LDAP_ENABLE_GROUP_CHECK_AFTER_KERBEROS);
        Filter filter = this.filter = this.enableLdapGroupCheck ? LdapAuthenticationProviderImpl.resolveFilter(conf) : null;
        if (this.enableLdapGroupCheck && this.filter == null) {
            LOG.warn("LDAP group check enabled but no filters configured");
        }
    }

    public boolean applyLdapFilter(String principal) {
        boolean bl;
        block10: {
            if (!this.enableLdapGroupCheck) {
                return true;
            }
            if (this.filter == null) {
                LOG.warn("LDAP group check enabled but no filters configured");
                return false;
            }
            String user = KerberosLdapFilterEnforcer.extractUserName(principal);
            DirSearch dirSearch = this.createDirSearch();
            try {
                this.filter.apply(dirSearch, user);
                LOG.debug("Principal {} passed LDAP filter validation", (Object)principal);
                bl = true;
                if (dirSearch == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (dirSearch != null) {
                        try {
                            dirSearch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Principal {} failed LDAP filter validation", (Object)principal, (Object)e);
                    return false;
                }
            }
            dirSearch.close();
        }
        return bl;
    }

    public boolean isFilterConfigured() {
        return this.enableLdapGroupCheck && this.filter != null;
    }

    private DirSearch createDirSearch() throws AuthenticationException {
        String bindPassword;
        char[] passwordChars;
        String bindDN = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_USER);
        try {
            passwordChars = this.conf.getPassword(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_PASSWORD.varname);
        }
        catch (IOException e) {
            throw new AuthenticationException("Failed to retrieve LDAP bind password");
        }
        String string = bindPassword = passwordChars == null ? null : new String(passwordChars);
        if (StringUtils.isBlank(bindDN) || StringUtils.isBlank(bindPassword)) {
            throw new AuthenticationException("LDAP bind credentials not configured");
        }
        return this.dirSearchFactory.getInstance(this.conf, bindDN, bindPassword);
    }

    @VisibleForTesting
    public static String extractUserName(String principal) {
        String[] parts = SaslRpcServer.splitKerberosName(principal);
        return parts.length > 0 ? parts[0] : principal;
    }
}

