/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.hive.hplsql.Conf;
import org.apache.hive.hplsql.Console;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.ResultListener;
import org.apache.hive.hplsql.Signal;
import org.apache.hive.hplsql.SqlCodes;
import org.apache.hive.hplsql.TypeException;
import org.apache.hive.hplsql.UndefinedIdentException;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryException;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.executor.QueryResult;
import org.apache.hive.hplsql.objects.Table;

public class Select {
    Exec exec = null;
    Stack<Var> stack = null;
    Conf conf;
    Console console;
    ResultListener resultListener = ResultListener.NONE;
    QueryExecutor queryExecutor;
    boolean trace = false;

    Select(Exec e, QueryExecutor queryExecutor) {
        this.exec = e;
        this.stack = this.exec.getStack();
        this.conf = this.exec.getConf();
        this.trace = this.exec.getTrace();
        this.console = this.exec.console;
        this.queryExecutor = queryExecutor;
    }

    public void setResultListener(ResultListener resultListener) {
        this.resultListener = resultListener;
    }

    public Integer select(HplsqlParser.Select_stmtContext ctx) {
        if (ctx.parent instanceof HplsqlParser.StmtContext) {
            this.exec.stmtConnList.clear();
            this.trace(ctx, "SELECT");
        }
        boolean oldBuildSql = this.exec.buildSql;
        this.exec.buildSql = true;
        StringBuilder sql = new StringBuilder();
        if (this.exec.getOffline()) {
            sql.append(this.exec.getText(ctx));
        } else {
            if (ctx.cte_select_stmt() != null) {
                sql.append(this.evalPop(ctx.cte_select_stmt()).toString());
                sql.append("\n");
            }
            sql.append(this.evalPop(ctx.fullselect_stmt()).toString());
        }
        this.exec.buildSql = oldBuildSql;
        if (!(ctx.parent instanceof HplsqlParser.StmtContext)) {
            this.exec.stackPush(sql);
            return 0;
        }
        if (this.trace && ctx.parent instanceof HplsqlParser.StmtContext) {
            this.trace(ctx, sql.toString());
        }
        if (this.exec.getOffline()) {
            this.trace(ctx, "Not executed - offline mode set");
            return 0;
        }
        QueryResult query = this.queryExecutor.executeQuery(sql.toString(), ctx);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.trace(ctx, "SELECT completed successfully");
        this.exec.setSqlSuccess();
        try {
            int intoCount = this.getIntoCount(ctx);
            if (intoCount > 0) {
                if (this.isBulkCollect(ctx)) {
                    this.trace(ctx, "SELECT BULK COLLECT INTO statement executed");
                    long rowIndex = 1L;
                    List<Table> tables = this.exec.intoTables(ctx, this.intoVariableNames(ctx, intoCount));
                    tables.forEach(Table::removeAll);
                    while (query.next()) {
                        for (int i = 0; i < intoCount; ++i) {
                            Table table = tables.get(i);
                            table.populate(query, rowIndex, i);
                        }
                        ++rowIndex;
                    }
                } else {
                    this.trace(ctx, "SELECT INTO statement executed");
                    if (query.next()) {
                        for (int i = 0; i < intoCount; ++i) {
                            this.populateVariable(ctx, query, i);
                        }
                        this.exec.incRowCount();
                        this.exec.setSqlSuccess();
                        if (query.next()) {
                            this.exec.setSqlCode(SqlCodes.TOO_MANY_ROWS);
                            this.exec.signal(Signal.Type.TOO_MANY_ROWS);
                        }
                    } else {
                        this.exec.setSqlCode(SqlCodes.NO_DATA_FOUND);
                        this.exec.signal(Signal.Type.NOTFOUND);
                    }
                }
            } else if (ctx.parent instanceof HplsqlParser.StmtContext) {
                this.resultListener.onMetadata(query.metadata());
                int cols = query.columnCount();
                if (this.trace) {
                    this.trace(ctx, "Standalone SELECT executed: " + cols + " columns in the result set");
                }
                while (query.next()) {
                    Object[] row = new Object[cols];
                    for (int i = 0; i < cols; ++i) {
                        row[i] = query.column(i, Object.class);
                        if (i > 0) {
                            this.console.print("\t");
                        }
                        this.console.print(String.valueOf(row[i]));
                    }
                    this.console.printLine("");
                    this.exec.incRowCount();
                    this.resultListener.onRow(row);
                }
            } else {
                this.trace(ctx, "Scalar subquery executed, first row and first column fetched only");
                if (query.next()) {
                    this.exec.stackPush(new Var().setValue(query, 1));
                    this.exec.setSqlSuccess();
                } else {
                    this.evalNull();
                    this.exec.setSqlCode(SqlCodes.NO_DATA_FOUND);
                }
            }
        }
        catch (QueryException e) {
            this.exec.signal(query);
            query.close();
            return 1;
        }
        query.close();
        return 0;
    }

    private void populateVariable(HplsqlParser.Select_stmtContext ctx, QueryResult query, int columnIndex) {
        String intoName = this.getIntoVariable(ctx, columnIndex);
        Var var = this.exec.findVariable(intoName);
        if (var != null) {
            if (var.type == Var.Type.HPL_OBJECT && var.value instanceof Table) {
                Table table = (Table)var.value;
                table.populate(query, this.getIntoTableIndex(ctx, columnIndex), columnIndex);
            } else if (var.type == Var.Type.ROW) {
                var.setRowValues(query);
            } else {
                var.setValue(query, columnIndex);
            }
        } else {
            throw new UndefinedIdentException((ParserRuleContext)ctx, intoName);
        }
        this.exec.trace(ctx, var, query.metadata(), columnIndex);
    }

    public Integer cte(HplsqlParser.Cte_select_stmtContext ctx) {
        int cnt = ctx.cte_select_stmt_item().size();
        StringBuilder sql = new StringBuilder();
        sql.append("WITH ");
        for (int i = 0; i < cnt; ++i) {
            HplsqlParser.Cte_select_stmt_itemContext c = ctx.cte_select_stmt_item(i);
            sql.append(c.qident().getText());
            if (c.cte_select_cols() != null) {
                sql.append(" " + Exec.getFormattedText(c.cte_select_cols()));
            }
            sql.append(" AS (");
            sql.append(this.evalPop(ctx.cte_select_stmt_item(i).fullselect_stmt()).toString());
            sql.append(")");
            if (i + 1 == cnt) continue;
            sql.append(",\n");
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fullselect(HplsqlParser.Fullselect_stmtContext ctx) {
        int cnt = ctx.fullselect_stmt_item().size();
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < cnt; ++i) {
            String part = this.evalPop(ctx.fullselect_stmt_item(i)).toString();
            sql.append(part);
            if (i + 1 == cnt) continue;
            sql.append("\n" + this.getText(ctx.fullselect_set_clause(i)) + "\n");
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer subselect(HplsqlParser.Subselect_stmtContext ctx) {
        Var opt;
        StringBuilder sql = new StringBuilder();
        sql.append(ctx.start.getText());
        this.exec.append(sql, this.evalPop(ctx.select_list()).toString(), ctx.start, ctx.select_list().getStart());
        Token last = ctx.select_list().stop;
        if (ctx.into_clause() != null) {
            last = ctx.into_clause().stop;
        }
        if (ctx.from_clause() != null) {
            this.exec.append(sql, this.evalPop(ctx.from_clause()).toString(), last, ctx.from_clause().getStart());
            last = ctx.from_clause().stop;
        } else if (this.conf.dualTable != null) {
            sql.append(" FROM " + this.conf.dualTable);
        }
        if (ctx.where_clause() != null) {
            this.exec.append(sql, this.evalPop(ctx.where_clause()).toString(), last, ctx.where_clause().getStart());
            last = ctx.where_clause().stop;
        }
        if (ctx.group_by_clause() != null) {
            this.exec.append(sql, this.getText(ctx.group_by_clause()), last, ctx.group_by_clause().getStart());
            last = ctx.group_by_clause().stop;
        }
        if (ctx.having_clause() != null) {
            this.exec.append(sql, this.getText(ctx.having_clause()), last, ctx.having_clause().getStart());
            last = ctx.having_clause().stop;
        }
        if (ctx.qualify_clause() != null) {
            this.exec.append(sql, this.getText(ctx.qualify_clause()), last, ctx.qualify_clause().getStart());
            last = ctx.qualify_clause().stop;
        }
        if (ctx.order_by_clause() != null) {
            this.exec.append(sql, this.getText(ctx.order_by_clause()), last, ctx.order_by_clause().getStart());
            last = ctx.order_by_clause().stop;
        }
        if (ctx.select_options() != null && !(opt = this.evalPop(ctx.select_options())).isNull()) {
            sql.append(" " + opt.toString());
        }
        if (ctx.select_list().select_list_limit() != null) {
            sql.append(" LIMIT " + String.valueOf(this.evalPop(ctx.select_list().select_list_limit().expr())));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer selectList(HplsqlParser.Select_listContext ctx) {
        StringBuilder sql = new StringBuilder();
        if (ctx.select_list_set() != null) {
            sql.append(this.exec.getText(ctx.select_list_set())).append(" ");
        }
        int cnt = ctx.select_list_item().size();
        for (int i = 0; i < cnt; ++i) {
            if (ctx.select_list_item(i).select_list_asterisk() == null) {
                sql.append(this.evalPop(ctx.select_list_item(i).expr()));
                if (ctx.select_list_item(i).select_list_alias() != null) {
                    sql.append(" " + this.exec.getText(ctx.select_list_item(i).select_list_alias()));
                }
            } else {
                sql.append(this.exec.getText(ctx.select_list_item(i).select_list_asterisk()));
            }
            if (i + 1 >= cnt) continue;
            sql.append(", ");
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer from(HplsqlParser.From_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append(ctx.T_FROM().getText()).append(" ");
        sql.append(this.evalPop(ctx.from_table_clause()));
        int cnt = ctx.from_join_clause().size();
        for (int i = 0; i < cnt; ++i) {
            sql.append(this.evalPop(ctx.from_join_clause(i)));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fromTable(HplsqlParser.From_table_name_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.evalPop(ctx.table_name()));
        if (ctx.from_alias_clause() != null) {
            sql.append(" ").append(this.exec.getText(ctx.from_alias_clause()));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fromSubselect(HplsqlParser.From_subselect_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        sql.append(this.evalPop(ctx.select_stmt()).toString());
        sql.append(")");
        if (ctx.from_alias_clause() != null) {
            sql.append(" ").append(this.exec.getText(ctx.from_alias_clause()));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fromJoin(HplsqlParser.From_join_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        if (ctx.T_COMMA() != null) {
            sql.append(", ");
            sql.append(this.evalPop(ctx.from_table_clause()));
        } else if (ctx.from_join_type_clause() != null) {
            sql.append(" ");
            sql.append(this.exec.getText(ctx.from_join_type_clause()));
            sql.append(" ");
            sql.append(this.evalPop(ctx.from_table_clause()));
            sql.append(" ");
            sql.append(this.exec.getText(ctx, ctx.T_ON().getSymbol(), ctx.bool_expr().getStop()));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fromTableValues(HplsqlParser.From_table_values_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        int rows = ctx.from_table_values_row().size();
        sql.append("(");
        for (int i = 0; i < rows; ++i) {
            int cols = ctx.from_table_values_row(i).expr().size();
            int cols_as = ctx.from_alias_clause().L_ID().size();
            sql.append("SELECT ");
            for (int j = 0; j < cols; ++j) {
                sql.append(this.evalPop(ctx.from_table_values_row(i).expr(j)));
                if (j < cols_as) {
                    sql.append(" AS ");
                    sql.append(ctx.from_alias_clause().L_ID(j));
                }
                if (j + 1 >= cols) continue;
                sql.append(", ");
            }
            if (this.conf.dualTable != null) {
                sql.append(" FROM " + this.conf.dualTable);
            }
            if (i + 1 >= rows) continue;
            sql.append("\nUNION ALL\n");
        }
        sql.append(") ");
        if (ctx.from_alias_clause() != null) {
            sql.append(ctx.from_alias_clause().qident().getText());
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer where(HplsqlParser.Where_clauseContext ctx) {
        boolean oldBuildSql = this.exec.buildSql;
        this.exec.buildSql = true;
        StringBuilder sql = new StringBuilder();
        sql.append(ctx.T_WHERE().getText());
        sql.append(" " + String.valueOf(this.evalPop(ctx.bool_expr())));
        this.exec.stackPush(sql);
        this.exec.buildSql = oldBuildSql;
        return 0;
    }

    HplsqlParser.Into_clauseContext getIntoClause(HplsqlParser.Select_stmtContext ctx) {
        if (ctx.fullselect_stmt().fullselect_stmt_item(0).subselect_stmt() != null) {
            return ctx.fullselect_stmt().fullselect_stmt_item(0).subselect_stmt().into_clause();
        }
        return null;
    }

    int getIntoCount(HplsqlParser.Select_stmtContext ctx) {
        HplsqlParser.Into_clauseContext into = this.getIntoClause(ctx);
        if (into != null) {
            return into.ident().size() + into.table_row().size();
        }
        List<HplsqlParser.Select_list_itemContext> sl = ctx.fullselect_stmt().fullselect_stmt_item(0).subselect_stmt().select_list().select_list_item();
        if (sl.get(0).T_EQUAL() != null) {
            return sl.size();
        }
        return 0;
    }

    private boolean isBulkCollect(HplsqlParser.Select_stmtContext ctx) {
        HplsqlParser.Into_clauseContext into = this.getIntoClause(ctx);
        return into != null && into.bulk_collect_clause() != null;
    }

    String getIntoVariable(HplsqlParser.Select_stmtContext ctx, int idx) {
        HplsqlParser.Into_clauseContext into = this.getIntoClause(ctx);
        if (into != null) {
            return into.table_row(idx) != null ? into.table_row(idx).ident().getText() : into.ident(idx).getText();
        }
        HplsqlParser.Select_list_itemContext sl = ctx.fullselect_stmt().fullselect_stmt_item(0).subselect_stmt().select_list().select_list_item(idx);
        if (sl != null) {
            return sl.qident().getText();
        }
        return null;
    }

    private List<String> intoVariableNames(HplsqlParser.Select_stmtContext ctx, int count) {
        return IntStream.range(0, count).mapToObj(i -> this.getIntoVariable(ctx, i)).collect(Collectors.toList());
    }

    private int getIntoTableIndex(HplsqlParser.Select_stmtContext ctx, int idx) {
        HplsqlParser.Into_clauseContext into = this.getIntoClause(ctx);
        HplsqlParser.Table_rowContext row = into.table_row(idx);
        if (row == null) {
            throw new TypeException((ParserRuleContext)ctx, "Missing into table index");
        }
        return Integer.parseInt(row.L_INT().getText());
    }

    public Integer option(HplsqlParser.Select_options_itemContext ctx) {
        if (ctx.T_LIMIT() != null) {
            this.exec.stackPush("LIMIT " + String.valueOf(this.evalPop(ctx.expr())));
        }
        return 0;
    }

    void evalNull() {
        this.exec.stackPush(Var.Null);
    }

    Var evalPop(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return Var.Empty;
    }

    String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    void trace(ParserRuleContext ctx, String message) {
        this.exec.trace(ctx, message);
    }
}

