/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.security.Provider;
import java.util.ArrayDeque;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.hadoop.hive.metastore.MetaStoreAuthenticationProviderFactory;

public class MetaStorePlainSaslServer
implements SaslServer {
    public static final String PLAIN_METHOD = "PLAIN";
    private String user;
    private final CallbackHandler handler;

    MetaStorePlainSaslServer(CallbackHandler handler, String authMethodStr) throws SaslException {
        this.handler = handler;
        MetaStoreAuthenticationProviderFactory.AuthMethods.getValidAuthMethod(authMethodStr);
    }

    @Override
    public String getMechanismName() {
        return PLAIN_METHOD;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            ArrayDeque<String> tokenList = new ArrayDeque<String>();
            StringBuilder messageToken = new StringBuilder();
            for (byte b : response) {
                if (b == 0) {
                    tokenList.addLast(messageToken.toString());
                    messageToken = new StringBuilder();
                    continue;
                }
                messageToken.append((char)b);
            }
            tokenList.addLast(messageToken.toString());
            if (tokenList.size() < 2 || tokenList.size() > 3) {
                throw new SaslException("Invalid message format");
            }
            String passwd = (String)tokenList.removeLast();
            this.user = (String)tokenList.removeLast();
            String authzId = tokenList.isEmpty() ? this.user : (String)tokenList.removeLast();
            if (this.user == null || this.user.isEmpty()) {
                throw new SaslException("No user name provided");
            }
            if (passwd == null || passwd.isEmpty()) {
                throw new SaslException("No password name provided");
            }
            NameCallback nameCallback = new NameCallback("User");
            nameCallback.setName(this.user);
            PasswordCallback pcCallback = new PasswordCallback("Password", false);
            pcCallback.setPassword(passwd.toCharArray());
            AuthorizeCallback acCallback = new AuthorizeCallback(this.user, authzId);
            Callback[] cbList = new Callback[]{nameCallback, pcCallback, acCallback};
            this.handler.handle(cbList);
            if (!acCallback.isAuthorized()) {
                throw new SaslException("Authentication failed");
            }
        }
        catch (IllegalStateException eL) {
            throw new SaslException("Invalid message format", eL);
        }
        catch (IOException eI) {
            throw new SaslException("Error validating the login", eI);
        }
        catch (UnsupportedCallbackException eU) {
            throw new SaslException("Error validating the login", eU);
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.user != null;
    }

    @Override
    public String getAuthorizationID() {
        return this.user;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() {
    }

    public static class SaslPlainProvider
    extends Provider {
        public SaslPlainProvider() {
            super("HiveMetaStoreSaslPlain", 1.0, "Hive MetaStore Plain SASL provider");
            this.put("SaslServerFactory.PLAIN", SaslPlainServerFactory.class.getName());
        }
    }

    public static class SaslPlainServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) {
            if (MetaStorePlainSaslServer.PLAIN_METHOD.equals(mechanism)) {
                try {
                    return new MetaStorePlainSaslServer(cbh, protocol);
                }
                catch (SaslException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{MetaStorePlainSaslServer.PLAIN_METHOD};
        }
    }
}

