/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.helpers;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.Validator;
import org.apache.hadoop.hive.llap.protocol.LlapTaskUmbilicalProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapTaskUmbilicalServer {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTaskUmbilicalServer.class);
    protected volatile Server server;
    private final InetSocketAddress address;
    private final AtomicBoolean started = new AtomicBoolean(true);
    private JobTokenSecretManager jobTokenSecretManager;
    private Map<String, int[]> tokenRefMap = new HashMap<String, int[]>();

    public LlapTaskUmbilicalServer(Configuration conf, LlapTaskUmbilicalProtocol umbilical, int numHandlers) throws IOException {
        this.jobTokenSecretManager = new JobTokenSecretManager(conf);
        String[] portRange = conf.get(HiveConf.ConfVars.LLAP_TASK_UMBILICAL_SERVER_PORT.varname).split("-");
        boolean isHadoopSecurityAuthorizationEnabled = conf.getBoolean("hadoop.security.authorization", false);
        int minPort = Integer.parseInt(portRange[0]);
        boolean portFound = false;
        BindException e = null;
        if (portRange.length == 1) {
            this.startServer(conf, umbilical, numHandlers, minPort, isHadoopSecurityAuthorizationEnabled);
            portFound = true;
            LOG.info("Successfully bound to port {}", (Object)minPort);
        } else {
            int maxPort = Integer.parseInt(portRange[1]);
            this.validatePortRange(portRange[0], portRange[1]);
            for (int i = minPort; i < maxPort; ++i) {
                try {
                    this.startServer(conf, umbilical, numHandlers, i, isHadoopSecurityAuthorizationEnabled);
                    portFound = true;
                    LOG.info("Successfully bound to port {}", (Object)i);
                    break;
                }
                catch (BindException be) {
                    LOG.warn("Unable to bind to port {}", (Object)i, (Object)be);
                    e = be;
                    continue;
                }
            }
        }
        if (!portFound) {
            throw e;
        }
        this.address = NetUtils.getConnectAddress(this.server);
        LOG.info("Started TaskUmbilicalServer: " + umbilical.getClass().getName() + " at address: " + String.valueOf(this.address) + " with numHandlers=" + numHandlers);
    }

    private void validatePortRange(String minPort, String maxPort) throws IOException {
        String valMax;
        Validator.RangeValidator rangeValidator = new Validator.RangeValidator(1024L, 65535L);
        String valMin = rangeValidator.validate(minPort);
        if (valMin == null & (valMax = rangeValidator.validate(maxPort)) == null) {
            throw new IOException("Invalid minimum range value: " + minPort + " and maximum range value: " + maxPort + " for " + HiveConf.ConfVars.LLAP_TASK_UMBILICAL_SERVER_PORT.varname + ". The value should be between 1024 and 65535.");
        }
        if (valMin != null) {
            throw new IOException("Invalid minimum range value :" + minPort + " for " + HiveConf.ConfVars.LLAP_TASK_UMBILICAL_SERVER_PORT.varname + ". The value should be between 1024 and 65535.");
        }
        if (valMax != null) {
            throw new IOException("Invalid maximum range value:" + maxPort + " for " + HiveConf.ConfVars.LLAP_TASK_UMBILICAL_SERVER_PORT.varname + ". The value should be between 1024 and 65535.");
        }
    }

    private void startServer(Configuration conf, LlapTaskUmbilicalProtocol umbilical, int numHandlers, int port, boolean isHadoopSecurityAuthorizationEnabled) throws IOException {
        this.server = new RPC.Builder(conf).setProtocol(LlapTaskUmbilicalProtocol.class).setBindAddress(IPStackUtils.resolveWildcardAddress()).setPort(port).setInstance((Object)umbilical).setNumHandlers(numHandlers).setSecretManager((SecretManager)this.jobTokenSecretManager).build();
        if (isHadoopSecurityAuthorizationEnabled) {
            this.server.refreshServiceAcl(conf, (PolicyProvider)new LlapUmbilicalExternalPolicyProvider());
        }
        this.server.start();
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getNumOpenConnections() {
        return this.server.getNumOpenConnections();
    }

    public synchronized void addTokenForJob(String tokenIdentifier, Token<JobTokenIdentifier> token) {
        int[] refCount = this.tokenRefMap.get(tokenIdentifier);
        if (refCount == null) {
            refCount = new int[]{0};
            this.tokenRefMap.put(tokenIdentifier, refCount);
            this.jobTokenSecretManager.addTokenForJob(tokenIdentifier, token);
        }
        refCount[0] = refCount[0] + 1;
    }

    public synchronized void removeTokenForJob(String tokenIdentifier) {
        int[] refCount = this.tokenRefMap.get(tokenIdentifier);
        if (refCount == null) {
            LOG.warn("No refCount found for tokenIdentifier " + tokenIdentifier);
        } else {
            refCount[0] = refCount[0] - 1;
            if (refCount[0] <= 0) {
                this.tokenRefMap.remove(tokenIdentifier);
                this.jobTokenSecretManager.removeTokenForJob(tokenIdentifier);
            }
        }
    }

    public void shutdownServer() {
        if (this.started.get()) {
            this.started.set(false);
            this.server.stop();
        }
    }

    public static class LlapUmbilicalExternalPolicyProvider
    extends PolicyProvider {
        private static final Service[] services = new Service[]{new Service("security.job.task.protocol.acl", LlapTaskUmbilicalProtocol.class)};

        public Service[] getServices() {
            return (Service[])services.clone();
        }
    }
}

