/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.ext;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.io.Writable;

public class LlapDaemonInfo
implements Writable {
    private String host;
    private int rpcPort;
    private int outputFormatPort;

    public LlapDaemonInfo(String host, int rpcPort, int outputFormatPort) {
        this.host = host;
        this.rpcPort = rpcPort;
        this.outputFormatPort = outputFormatPort;
    }

    public LlapDaemonInfo() {
    }

    public String getHost() {
        return this.host;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public int getOutputFormatPort() {
        return this.outputFormatPort;
    }

    public String toString() {
        return "LlapDaemonInfo{host='" + this.host + "', rpcPort=" + this.rpcPort + ", outputFormatPort=" + this.outputFormatPort + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LlapDaemonInfo that = (LlapDaemonInfo)o;
        return this.rpcPort == that.rpcPort && this.outputFormatPort == that.outputFormatPort && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.rpcPort, this.outputFormatPort);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.host);
        out.writeInt(this.rpcPort);
        out.writeInt(this.outputFormatPort);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.host = in.readUTF();
        this.rpcPort = in.readInt();
        this.outputFormatPort = in.readInt();
    }
}

