/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public enum StorageType {
    RAM_DISK(true, true),
    SSD(false, false),
    DISK(false, false),
    ARCHIVE(false, false),
    PROVIDED(false, false),
    NVDIMM(false, true);

    private final boolean isTransient;
    private final boolean isRAM;
    public static final StorageType DEFAULT;
    public static final StorageType[] EMPTY_ARRAY;
    private static final StorageType[] VALUES;
    public static final String CONF_KEY_HEADER = "dfs.datanode.storagetype.";

    private StorageType(boolean isTransient, boolean isRAM) {
        this.isTransient = isTransient;
        this.isRAM = isRAM;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isRAM() {
        return this.isRAM;
    }

    public boolean supportTypeQuota() {
        return !this.isTransient;
    }

    public boolean isMovable() {
        return !this.isTransient;
    }

    public static List<StorageType> asList() {
        return Arrays.asList(VALUES);
    }

    public static List<StorageType> getMovableTypes() {
        return StorageType.getNonTransientTypes();
    }

    public static List<StorageType> getTypesSupportingQuota() {
        return StorageType.getNonTransientTypes();
    }

    public static StorageType parseStorageType(int i) {
        return VALUES[i];
    }

    public static StorageType parseStorageType(String s2) {
        return StorageType.valueOf(StringUtils.toUpperCase(s2));
    }

    public static boolean allowSameDiskTiering(StorageType storageType) {
        return storageType == DISK || storageType == ARCHIVE;
    }

    private static List<StorageType> getNonTransientTypes() {
        ArrayList<StorageType> nonTransientTypes = new ArrayList<StorageType>();
        for (StorageType t2 : VALUES) {
            if (t2.isTransient) continue;
            nonTransientTypes.add(t2);
        }
        return nonTransientTypes;
    }

    public static String getConf(Configuration conf, StorageType t2, String name) {
        return conf.get(CONF_KEY_HEADER + t2.toString() + "." + name);
    }

    static {
        DEFAULT = DISK;
        EMPTY_ARRAY = new StorageType[0];
        VALUES = StorageType.values();
    }
}

