/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.timeout;

import org.apache.hive.druid.io.netty.util.Timeout;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.util.DateUtils;
import org.asynchttpclient.util.StringBuilderPool;

public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    private final long requestTimeout;

    RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, int requestTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.requestTimeout = requestTimeout;
    }

    public void run(Timeout timeout) {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        this.timeoutsHolder.cancel();
        if (this.nettyResponseFuture.isDone()) {
            return;
        }
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append("Request timeout to ");
        this.appendRemoteAddress(sb);
        String message = sb.append(" after ").append(this.requestTimeout).append(" ms").toString();
        long age = DateUtils.unpreciseMillisTime() - this.nettyResponseFuture.getStart();
        this.expire(message, age);
    }
}

