/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.channel.ChannelPoolPartitioning;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.asynchttpclient.netty.request.NettyRequest;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyResponseFuture<V>
implements ListenableFuture<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyResponseFuture.class);
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture> REDIRECT_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(NettyResponseFuture.class, "redirectCount");
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture> CURRENT_RETRY_UPDATER = AtomicIntegerFieldUpdater.newUpdater(NettyResponseFuture.class, "currentRetry");
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture> IS_DONE_FIELD = AtomicIntegerFieldUpdater.newUpdater(NettyResponseFuture.class, "isDone");
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture> IS_CANCELLED_FIELD = AtomicIntegerFieldUpdater.newUpdater(NettyResponseFuture.class, "isCancelled");
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture> IN_AUTH_FIELD = AtomicIntegerFieldUpdater.newUpdater(NettyResponseFuture.class, "inAuth");
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture> IN_PROXY_AUTH_FIELD = AtomicIntegerFieldUpdater.newUpdater(NettyResponseFuture.class, "inProxyAuth");
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture> CONTENT_PROCESSED_FIELD = AtomicIntegerFieldUpdater.newUpdater(NettyResponseFuture.class, "contentProcessed");
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture> ON_THROWABLE_CALLED_FIELD = AtomicIntegerFieldUpdater.newUpdater(NettyResponseFuture.class, "onThrowableCalled");
    private static final AtomicReferenceFieldUpdater<NettyResponseFuture, TimeoutsHolder> TIMEOUTS_HOLDER_FIELD = AtomicReferenceFieldUpdater.newUpdater(NettyResponseFuture.class, TimeoutsHolder.class, "timeoutsHolder");
    private static final AtomicReferenceFieldUpdater<NettyResponseFuture, Object> PARTITION_KEY_LOCK_FIELD = AtomicReferenceFieldUpdater.newUpdater(NettyResponseFuture.class, Object.class, "partitionKeyLock");
    private final long start = DateUtils.unpreciseMillisTime();
    private final ChannelPoolPartitioning connectionPoolPartitioning;
    private final ConnectionSemaphore connectionSemaphore;
    private final ProxyServer proxyServer;
    private final int maxRetry;
    private final CompletableFuture<V> future = new CompletableFuture();
    public Throwable pendingException;
    private volatile int isDone = 0;
    private volatile int isCancelled = 0;
    private volatile int inAuth = 0;
    private volatile int inProxyAuth = 0;
    private volatile int statusReceived = 0;
    private volatile int contentProcessed = 0;
    private volatile int onThrowableCalled = 0;
    private volatile TimeoutsHolder timeoutsHolder;
    private volatile Object partitionKeyLock;
    private volatile int redirectCount = 0;
    private volatile int currentRetry = 0;
    private volatile long touch = DateUtils.unpreciseMillisTime();
    private volatile ChannelState channelState = ChannelState.NEW;
    private Channel channel;
    private boolean keepAlive = true;
    private Request targetRequest;
    private Request currentRequest;
    private NettyRequest nettyRequest;
    private AsyncHandler<V> asyncHandler;
    private boolean streamAlreadyConsumed;
    private boolean reuseChannel;
    private boolean headersAlreadyWrittenOnContinue;
    private boolean dontWriteBodyBecauseExpectContinue;
    private boolean allowConnect;
    private Realm realm;
    private Realm proxyRealm;

    public NettyResponseFuture(Request originalRequest, AsyncHandler<V> asyncHandler, NettyRequest nettyRequest, int maxRetry, ChannelPoolPartitioning connectionPoolPartitioning, ConnectionSemaphore connectionSemaphore, ProxyServer proxyServer) {
        this.asyncHandler = asyncHandler;
        this.targetRequest = this.currentRequest = originalRequest;
        this.nettyRequest = nettyRequest;
        this.connectionPoolPartitioning = connectionPoolPartitioning;
        this.connectionSemaphore = connectionSemaphore;
        this.proxyServer = proxyServer;
        this.maxRetry = maxRetry;
    }

    private void releasePartitionKeyLock() {
        if (this.connectionSemaphore == null) {
            return;
        }
        Object partitionKey = this.takePartitionKeyLock();
        if (partitionKey != null) {
            this.connectionSemaphore.releaseChannelLock(partitionKey);
        }
    }

    public Object takePartitionKeyLock() {
        if (this.partitionKeyLock == null) {
            return null;
        }
        return PARTITION_KEY_LOCK_FIELD.getAndSet(this, null);
    }

    @Override
    public boolean isDone() {
        return this.isDone != 0 || this.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled != 0;
    }

    @Override
    public boolean cancel(boolean force) {
        this.releasePartitionKeyLock();
        this.cancelTimeouts();
        if (IS_CANCELLED_FIELD.getAndSet(this, 1) != 0) {
            return false;
        }
        if (this.channel != null) {
            Channels.setDiscard(this.channel);
            Channels.silentlyCloseChannel(this.channel);
        }
        if (ON_THROWABLE_CALLED_FIELD.getAndSet(this, 1) == 0) {
            try {
                this.asyncHandler.onThrowable(new CancellationException());
            }
            catch (Throwable t) {
                LOGGER.warn("cancel", t);
            }
        }
        this.future.cancel(false);
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public V get(long l, TimeUnit tu) throws InterruptedException, TimeoutException, ExecutionException {
        return this.future.get(l, tu);
    }

    private void loadContent() throws ExecutionException {
        if (this.future.isDone()) {
            try {
                this.future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("unreachable", e);
            }
        }
        CURRENT_RETRY_UPDATER.set(this, this.maxRetry);
        if (CONTENT_PROCESSED_FIELD.getAndSet(this, 1) == 0) {
            try {
                this.future.complete(this.asyncHandler.onCompleted());
            }
            catch (Throwable ex) {
                if (ON_THROWABLE_CALLED_FIELD.getAndSet(this, 1) == 0) {
                    try {
                        try {
                            this.asyncHandler.onThrowable(ex);
                        }
                        catch (Throwable t) {
                            LOGGER.debug("asyncHandler.onThrowable", t);
                        }
                    }
                    finally {
                        this.cancelTimeouts();
                    }
                }
                this.future.completeExceptionally(ex);
            }
        }
        this.future.getNow(null);
    }

    private boolean terminateAndExit() {
        this.releasePartitionKeyLock();
        this.cancelTimeouts();
        this.channel = null;
        this.reuseChannel = false;
        return IS_DONE_FIELD.getAndSet(this, 1) != 0 || this.isCancelled != 0;
    }

    @Override
    public final void done() {
        if (this.terminateAndExit()) {
            return;
        }
        try {
            this.loadContent();
        }
        catch (ExecutionException executionException) {
        }
        catch (RuntimeException t) {
            this.future.completeExceptionally(t);
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
            throw t;
        }
    }

    @Override
    public final void abort(Throwable t) {
        if (this.terminateAndExit()) {
            return;
        }
        this.future.completeExceptionally(t);
        if (ON_THROWABLE_CALLED_FIELD.compareAndSet(this, 0, 1)) {
            try {
                this.asyncHandler.onThrowable(t);
            }
            catch (Throwable te) {
                LOGGER.debug("asyncHandler.onThrowable", te);
            }
        }
    }

    @Override
    public void touch() {
        this.touch = DateUtils.unpreciseMillisTime();
    }

    @Override
    public ListenableFuture<V> addListener(Runnable listener, Executor exec) {
        if (exec == null) {
            exec = Runnable::run;
        }
        this.future.whenCompleteAsync((r, v) -> listener.run(), exec);
        return this;
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        return this.future;
    }

    public Uri getUri() {
        return this.targetRequest.getUri();
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public void cancelTimeouts() {
        TimeoutsHolder ref = TIMEOUTS_HOLDER_FIELD.getAndSet(this, null);
        if (ref != null) {
            ref.cancel();
        }
    }

    public final Request getTargetRequest() {
        return this.targetRequest;
    }

    public void setTargetRequest(Request targetRequest) {
        this.targetRequest = targetRequest;
    }

    public final Request getCurrentRequest() {
        return this.currentRequest;
    }

    public void setCurrentRequest(Request currentRequest) {
        this.currentRequest = currentRequest;
    }

    public final NettyRequest getNettyRequest() {
        return this.nettyRequest;
    }

    public final void setNettyRequest(NettyRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
    }

    public final AsyncHandler<V> getAsyncHandler() {
        return this.asyncHandler;
    }

    public void setAsyncHandler(AsyncHandler<V> asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public final boolean isKeepAlive() {
        return this.keepAlive;
    }

    public final void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int incrementAndGetCurrentRedirectCount() {
        return REDIRECT_COUNT_UPDATER.incrementAndGet(this);
    }

    public TimeoutsHolder getTimeoutsHolder() {
        return TIMEOUTS_HOLDER_FIELD.get(this);
    }

    public void setTimeoutsHolder(TimeoutsHolder timeoutsHolder) {
        TIMEOUTS_HOLDER_FIELD.set(this, timeoutsHolder);
    }

    public boolean isInAuth() {
        return this.inAuth != 0;
    }

    public void setInAuth(boolean inAuth) {
        this.inAuth = inAuth ? 1 : 0;
    }

    public boolean isAndSetInAuth(boolean set) {
        return IN_AUTH_FIELD.getAndSet(this, set ? 1 : 0) != 0;
    }

    public boolean isInProxyAuth() {
        return this.inProxyAuth != 0;
    }

    public void setInProxyAuth(boolean inProxyAuth) {
        this.inProxyAuth = inProxyAuth ? 1 : 0;
    }

    public boolean isAndSetInProxyAuth(boolean inProxyAuth) {
        return IN_PROXY_AUTH_FIELD.getAndSet(this, inProxyAuth ? 1 : 0) != 0;
    }

    public ChannelState getChannelState() {
        return this.channelState;
    }

    public void setChannelState(ChannelState channelState) {
        this.channelState = channelState;
    }

    public boolean isStreamConsumed() {
        return this.streamAlreadyConsumed;
    }

    public void setStreamConsumed(boolean streamConsumed) {
        this.streamAlreadyConsumed = streamConsumed;
    }

    public long getLastTouch() {
        return this.touch;
    }

    public boolean isHeadersAlreadyWrittenOnContinue() {
        return this.headersAlreadyWrittenOnContinue;
    }

    public void setHeadersAlreadyWrittenOnContinue(boolean headersAlreadyWrittenOnContinue) {
        this.headersAlreadyWrittenOnContinue = headersAlreadyWrittenOnContinue;
    }

    public boolean isDontWriteBodyBecauseExpectContinue() {
        return this.dontWriteBodyBecauseExpectContinue;
    }

    public void setDontWriteBodyBecauseExpectContinue(boolean dontWriteBodyBecauseExpectContinue) {
        this.dontWriteBodyBecauseExpectContinue = dontWriteBodyBecauseExpectContinue;
    }

    public boolean isConnectAllowed() {
        return this.allowConnect;
    }

    public void setConnectAllowed(boolean allowConnect) {
        this.allowConnect = allowConnect;
    }

    public void attachChannel(Channel channel, boolean reuseChannel) {
        if (this.isDone()) {
            Channels.silentlyCloseChannel(channel);
        }
        this.channel = channel;
        this.reuseChannel = reuseChannel;
    }

    public Channel channel() {
        return this.channel;
    }

    public boolean isReuseChannel() {
        return this.reuseChannel;
    }

    public void setReuseChannel(boolean reuseChannel) {
        this.reuseChannel = reuseChannel;
    }

    public boolean incrementRetryAndCheck() {
        return this.maxRetry > 0 && CURRENT_RETRY_UPDATER.incrementAndGet(this) <= this.maxRetry;
    }

    public boolean isReplayPossible() {
        return !this.isDone() && (!Channels.isChannelActive(this.channel) || this.getUri().getScheme().equalsIgnoreCase("https")) && this.inAuth == 0 && this.inProxyAuth == 0;
    }

    public long getStart() {
        return this.start;
    }

    public Object getPartitionKey() {
        return this.connectionPoolPartitioning.getPartitionKey(this.targetRequest.getUri(), this.targetRequest.getVirtualHost(), this.proxyServer);
    }

    public void acquirePartitionLockLazily() throws IOException {
        if (this.connectionSemaphore == null || this.partitionKeyLock != null) {
            return;
        }
        Object partitionKey = this.getPartitionKey();
        this.connectionSemaphore.acquireChannelLock(partitionKey);
        Object prevKey = PARTITION_KEY_LOCK_FIELD.getAndSet(this, partitionKey);
        if (prevKey != null) {
            this.connectionSemaphore.releaseChannelLock(prevKey);
            this.releasePartitionKeyLock();
            throw new IllegalStateException("Trying to acquire partition lock concurrently. Please report.");
        }
        if (this.isDone()) {
            this.releasePartitionKeyLock();
        }
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    public Realm getProxyRealm() {
        return this.proxyRealm;
    }

    public void setProxyRealm(Realm proxyRealm) {
        this.proxyRealm = proxyRealm;
    }

    public String toString() {
        return "NettyResponseFuture{currentRetry=" + this.currentRetry + ",\n\tisDone=" + this.isDone + ",\n\tisCancelled=" + this.isCancelled + ",\n\tasyncHandler=" + this.asyncHandler + ",\n\tnettyRequest=" + this.nettyRequest + ",\n\tfuture=" + this.future + ",\n\turi=" + this.getUri() + ",\n\tkeepAlive=" + this.keepAlive + ",\n\tredirectCount=" + this.redirectCount + ",\n\ttimeoutsHolder=" + TIMEOUTS_HOLDER_FIELD.get(this) + ",\n\tinAuth=" + this.inAuth + ",\n\tstatusReceived=" + this.statusReceived + ",\n\ttouch=" + this.touch + '}';
    }
}

