/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.roaringbitmap;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.hive.druid.org.roaringbitmap.BatchIterator;
import org.apache.hive.druid.org.roaringbitmap.IntConsumer;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;
import org.apache.hive.druid.org.roaringbitmap.PeekableIntIterator;

public interface ImmutableBitmapDataProvider {
    public boolean contains(int var1);

    public int getCardinality();

    public long getLongCardinality();

    public void forEach(IntConsumer var1);

    public PeekableIntIterator getIntIterator();

    public PeekableIntIterator getSignedIntIterator();

    public IntIterator getReverseIntIterator();

    default public IntStream stream() {
        int characteristics = 85;
        Spliterator.OfInt x = Spliterators.spliterator(new RoaringOfInt(this.getIntIterator()), (long)this.getCardinality(), characteristics);
        return StreamSupport.intStream(x, false);
    }

    default public IntStream reverseStream() {
        int characteristics = 81;
        Spliterator.OfInt x = Spliterators.spliterator(new RoaringOfInt(this.getReverseIntIterator()), (long)this.getCardinality(), characteristics);
        return StreamSupport.intStream(x, false);
    }

    public BatchIterator getBatchIterator();

    public int getSizeInBytes();

    public long getLongSizeInBytes();

    public boolean isEmpty();

    public ImmutableBitmapDataProvider limit(int var1);

    public int rank(int var1);

    public long rankLong(int var1);

    public long rangeCardinality(long var1, long var3);

    public int select(int var1);

    public int first();

    public int last();

    public int firstSigned();

    public int lastSigned();

    public long nextValue(int var1);

    public long previousValue(int var1);

    public long nextAbsentValue(int var1);

    public long previousAbsentValue(int var1);

    public void serialize(DataOutput var1) throws IOException;

    public void serialize(ByteBuffer var1);

    public int serializedSizeInBytes();

    public int[] toArray();

    public static final class RoaringOfInt
    implements PrimitiveIterator.OfInt {
        private final IntIterator iterator;

        public RoaringOfInt(IntIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public int nextInt() {
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

