/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ObjectMap;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ObjectSortedMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectSortedMap;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortComparators;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import it.unimi.dsi.fastutil.shorts.ShortSortedSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.timeline.Overshadowable;
import org.apache.hive.druid.org.apache.druid.timeline.partition.AtomicUpdateGroup;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;

class OvershadowableManager<T extends Overshadowable<T>> {
    private final Map<Integer, PartitionChunk<T>> knownPartitionChunks;
    private final TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> standbyGroups;
    private final TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> visibleGroup;
    private final TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> overshadowedGroups;

    OvershadowableManager() {
        this.knownPartitionChunks = new HashMap<Integer, PartitionChunk<T>>();
        this.standbyGroups = new TreeMap();
        this.visibleGroup = new TreeMap();
        this.overshadowedGroups = new TreeMap();
    }

    OvershadowableManager(OvershadowableManager<T> other) {
        this.knownPartitionChunks = new HashMap<Integer, PartitionChunk<T>>(other.knownPartitionChunks);
        this.standbyGroups = new TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>>(other.standbyGroups);
        this.visibleGroup = new TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>>(other.visibleGroup);
        this.overshadowedGroups = new TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>>(other.overshadowedGroups);
    }

    private OvershadowableManager(List<AtomicUpdateGroup<T>> groups) {
        this();
        for (AtomicUpdateGroup<T> entry : groups) {
            for (PartitionChunk<T> chunk : entry.getChunks()) {
                this.addChunk(chunk);
            }
        }
    }

    private TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> getStateMap(State state) {
        switch (state) {
            case STANDBY: {
                return this.standbyGroups;
            }
            case VISIBLE: {
                return this.visibleGroup;
            }
            case OVERSHADOWED: {
                return this.overshadowedGroups;
            }
        }
        throw new ISE("Unknown state[%s]", new Object[]{state});
    }

    private Short2ObjectSortedMap<AtomicUpdateGroup<T>> createMinorVersionToAugMap(State state) {
        switch (state) {
            case STANDBY: 
            case OVERSHADOWED: {
                return new Short2ObjectRBTreeMap<AtomicUpdateGroup<T>>();
            }
            case VISIBLE: {
                return new SingleEntryShort2ObjectSortedMap<AtomicUpdateGroup<T>>();
            }
        }
        throw new ISE("Unknown state[%s]", new Object[]{state});
    }

    private void transitAtomicUpdateGroupState(AtomicUpdateGroup<T> atomicUpdateGroup, State from, State to) {
        Preconditions.checkNotNull(atomicUpdateGroup, "atomicUpdateGroup");
        Preconditions.checkArgument(!atomicUpdateGroup.isEmpty(), "empty atomicUpdateGroup");
        this.removeFrom(atomicUpdateGroup, from);
        this.addAtomicUpdateGroupWithState(atomicUpdateGroup, to, false);
    }

    private void replaceVisibleWith(Collection<AtomicUpdateGroup<T>> oldVisibleGroups, State newStateOfOldVisibleGroup, List<AtomicUpdateGroup<T>> newVisibleGroups, State oldStateOfNewVisibleGroups) {
        oldVisibleGroups.forEach(group -> {
            if (!group.isEmpty()) {
                this.removeFrom((AtomicUpdateGroup<T>)group, State.VISIBLE);
            }
        });
        newVisibleGroups.forEach(entry -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)entry, oldStateOfNewVisibleGroups, State.VISIBLE));
        oldVisibleGroups.forEach(group -> {
            if (!group.isEmpty()) {
                this.addAtomicUpdateGroupWithState((AtomicUpdateGroup<T>)group, newStateOfOldVisibleGroup, false);
            }
        });
    }

    @Nullable
    private AtomicUpdateGroup<T> findAtomicUpdateGroupWith(PartitionChunk<T> chunk, State state) {
        AtomicUpdateGroup atomicUpdateGroup;
        Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup = this.getStateMap(state).get(RootPartitionRange.of(chunk));
        if (versionToGroup != null && (atomicUpdateGroup = (AtomicUpdateGroup)versionToGroup.get(((Overshadowable)chunk.getObject()).getMinorVersion())) != null) {
            return atomicUpdateGroup;
        }
        return null;
    }

    @Nullable
    private AtomicUpdateGroup<T> tryRemoveChunkFromGroupWithState(PartitionChunk<T> chunk, State state) {
        AtomicUpdateGroup atomicUpdateGroup;
        RootPartitionRange rangeKey = RootPartitionRange.of(chunk);
        Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup = this.getStateMap(state).get(rangeKey);
        if (versionToGroup != null && (atomicUpdateGroup = (AtomicUpdateGroup)versionToGroup.get(((Overshadowable)chunk.getObject()).getMinorVersion())) != null) {
            atomicUpdateGroup.remove(chunk);
            if (atomicUpdateGroup.isEmpty()) {
                versionToGroup.remove(((Overshadowable)chunk.getObject()).getMinorVersion());
                if (versionToGroup.isEmpty()) {
                    this.getStateMap(state).remove(rangeKey);
                }
            }
            this.determineVisibleGroupAfterRemove(atomicUpdateGroup, RootPartitionRange.of(chunk), ((Overshadowable)chunk.getObject()).getMinorVersion(), state);
            return atomicUpdateGroup;
        }
        return null;
    }

    private List<AtomicUpdateGroup<T>> findOvershadowedBy(AtomicUpdateGroup<T> aug, State fromState) {
        RootPartitionRange rangeKeyOfGivenAug = RootPartitionRange.of(aug);
        return this.findOvershadowedBy(rangeKeyOfGivenAug, aug.getMinorVersion(), fromState);
    }

    @VisibleForTesting
    List<AtomicUpdateGroup<T>> findOvershadowedBy(RootPartitionRange rangeOfAug, short minorVersion, State fromState) {
        TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> stateMap = this.getStateMap(fromState);
        Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> current = this.findLowestOverlappingEntry(rangeOfAug, stateMap, true);
        if (current == null) {
            return Collections.emptyList();
        }
        ArrayList<AtomicUpdateGroup<T>> found = new ArrayList<AtomicUpdateGroup<T>>();
        while (current != null && rangeOfAug.overlaps(current.getKey())) {
            Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup;
            if (rangeOfAug.contains(current.getKey()) && (versionToGroup = current.getValue()).firstShortKey() < minorVersion) {
                found.addAll(versionToGroup.headMap(minorVersion).values());
            }
            current = stateMap.higherEntry(current.getKey());
        }
        return found;
    }

    private List<AtomicUpdateGroup<T>> findOvershadows(AtomicUpdateGroup<T> aug, State fromState) {
        return this.findOvershadows(RootPartitionRange.of(aug), aug.getMinorVersion(), fromState);
    }

    @VisibleForTesting
    List<AtomicUpdateGroup<T>> findOvershadows(RootPartitionRange rangeOfAug, short minorVersion, State fromState) {
        TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> stateMap = this.getStateMap(fromState);
        Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> current = this.findLowestOverlappingEntry(rangeOfAug, stateMap, false);
        if (current == null) {
            return Collections.emptyList();
        }
        ArrayList<AtomicUpdateGroup<T>> found = new ArrayList<AtomicUpdateGroup<T>>();
        while (current != null && current.getKey().overlaps(rangeOfAug)) {
            Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup;
            if (current.getKey().contains(rangeOfAug) && (versionToGroup = current.getValue()).lastShortKey() > minorVersion) {
                found.addAll(versionToGroup.tailMap(minorVersion).values());
            }
            current = stateMap.higherEntry(current.getKey());
        }
        return found;
    }

    @Nullable
    private Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> findLowestOverlappingEntry(RootPartitionRange rangeOfAug, TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> stateMap, boolean strictSameStartId) {
        Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> lowerEntry;
        Map.Entry<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> current = stateMap.floorEntry(rangeOfAug);
        if (current == null) {
            current = stateMap.higherEntry(rangeOfAug);
        }
        if (current == null) {
            return null;
        }
        while (current != null && !current.getKey().overlaps(rangeOfAug)) {
            current = stateMap.higherEntry(current.getKey());
        }
        BiPredicate<RootPartitionRange, RootPartitionRange> predicate = strictSameStartId ? (entryRange, groupRange) -> ((RootPartitionRange)entryRange).startPartitionId == ((RootPartitionRange)groupRange).startPartitionId : RootPartitionRange::overlaps;
        while (current != null && (lowerEntry = stateMap.lowerEntry(current.getKey())) != null && predicate.test(lowerEntry.getKey(), rangeOfAug)) {
            current = lowerEntry;
        }
        return current;
    }

    private void determineVisibleGroupAfterAdd(AtomicUpdateGroup<T> aug, State stateOfAug) {
        if (stateOfAug == State.STANDBY) {
            this.moveNewStandbyToVisibleIfNecessary(aug, stateOfAug);
        } else if (stateOfAug == State.OVERSHADOWED) {
            this.checkVisibleIsFullyAvailableAndTryToMoveOvershadowedToVisible(aug, stateOfAug);
        }
    }

    private void moveNewStandbyToVisibleIfNecessary(AtomicUpdateGroup<T> standbyGroup, State stateOfGroup) {
        assert (stateOfGroup == State.STANDBY);
        if (standbyGroup.isFull()) {
            this.replaceVisibleWith(this.findOvershadowedBy(standbyGroup, State.VISIBLE), State.OVERSHADOWED, Collections.singletonList(standbyGroup), State.STANDBY);
            this.findOvershadowedBy(standbyGroup, State.STANDBY).forEach(entry -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)entry, State.STANDBY, State.OVERSHADOWED));
        } else if (!standbyGroup.isEmpty()) {
            List<AtomicUpdateGroup<T>> overshadowedVisibles = this.findOvershadowedBy(standbyGroup, State.VISIBLE);
            if (overshadowedVisibles.isEmpty()) {
                this.transitAtomicUpdateGroupState(standbyGroup, State.STANDBY, State.VISIBLE);
                this.findOvershadowedBy(standbyGroup, State.STANDBY).forEach(entry -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)entry, State.STANDBY, State.OVERSHADOWED));
            } else {
                boolean fullyCoverAugRange = this.doGroupsFullyCoverPartitionRange(overshadowedVisibles, standbyGroup.getStartRootPartitionId(), standbyGroup.getEndRootPartitionId());
                if (!fullyCoverAugRange) {
                    this.replaceVisibleWith(overshadowedVisibles, State.OVERSHADOWED, Collections.singletonList(standbyGroup), State.STANDBY);
                    this.findOvershadowedBy(standbyGroup, State.STANDBY).forEach(entry -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)entry, State.STANDBY, State.OVERSHADOWED));
                }
            }
        }
    }

    private void checkVisibleIsFullyAvailableAndTryToMoveOvershadowedToVisible(AtomicUpdateGroup<T> group, State stateOfGroup) {
        assert (stateOfGroup == State.OVERSHADOWED);
        if (group.isFull()) {
            boolean isOvershadowedGroupsFull;
            List<AtomicUpdateGroup<T>> latestFullGroups;
            boolean isOvershadowingGroupsFull;
            List<AtomicUpdateGroup<T>> groupsOvershadowingAug;
            List<AtomicUpdateGroup<T>> overshadowingVisibles = this.findOvershadows(group, State.VISIBLE);
            if (overshadowingVisibles.isEmpty()) {
                List<AtomicUpdateGroup<T>> overshadowingStandbys = this.findLatestNonFullyAvailableAtomicUpdateGroups(this.findOvershadows(group, State.STANDBY));
                if (overshadowingStandbys.isEmpty()) {
                    throw new ISE("WTH? atomicUpdateGroup[%s] is in overshadowed state, but no one overshadows it?", group);
                }
                groupsOvershadowingAug = overshadowingStandbys;
                isOvershadowingGroupsFull = false;
            } else {
                groupsOvershadowingAug = overshadowingVisibles;
                isOvershadowingGroupsFull = this.doGroupsFullyCoverPartitionRange(groupsOvershadowingAug, groupsOvershadowingAug.get(0).getStartRootPartitionId(), groupsOvershadowingAug.get(groupsOvershadowingAug.size() - 1).getEndRootPartitionId());
            }
            if (!isOvershadowingGroupsFull && !(latestFullGroups = groupsOvershadowingAug.stream().flatMap(eachFullgroup -> this.findLatestFullyAvailableOvershadowedAtomicUpdateGroups(RootPartitionRange.of(eachFullgroup), eachFullgroup.getMinorVersion()).stream()).collect(Collectors.toList())).isEmpty() && (isOvershadowedGroupsFull = this.doGroupsFullyCoverPartitionRange(latestFullGroups, groupsOvershadowingAug.get(0).getStartRootPartitionId(), groupsOvershadowingAug.get(groupsOvershadowingAug.size() - 1).getEndRootPartitionId()))) {
                this.replaceVisibleWith(overshadowingVisibles, State.STANDBY, latestFullGroups, State.OVERSHADOWED);
            }
        }
    }

    private boolean doGroupsFullyCoverPartitionRange(List<AtomicUpdateGroup<T>> groups, int startRootPartitionId, int endRootPartitionId) {
        int startRootPartitionIdOfOvershadowed = groups.get(0).getStartRootPartitionId();
        int endRootPartitionIdOfOvershadowed = groups.get(groups.size() - 1).getEndRootPartitionId();
        if (startRootPartitionId != startRootPartitionIdOfOvershadowed || endRootPartitionId != endRootPartitionIdOfOvershadowed) {
            return false;
        }
        int prevEndPartitionId = groups.get(0).getStartRootPartitionId();
        for (AtomicUpdateGroup<T> group : groups) {
            if (!group.isFull() || prevEndPartitionId != group.getStartRootPartitionId()) {
                return false;
            }
            prevEndPartitionId = group.getEndRootPartitionId();
        }
        return true;
    }

    private void addAtomicUpdateGroupWithState(AtomicUpdateGroup<T> aug, State state, boolean determineVisible) {
        AtomicUpdateGroup<T> existing = this.getStateMap(state).computeIfAbsent(RootPartitionRange.of(aug), k -> this.createMinorVersionToAugMap(state)).put(aug.getMinorVersion(), aug);
        if (existing != null) {
            throw new ISE("AtomicUpdateGroup[%s] is already in state[%s]", new Object[]{existing, state});
        }
        if (determineVisible) {
            this.determineVisibleGroupAfterAdd(aug, state);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean addChunk(PartitionChunk<T> chunk) {
        PartitionChunk<T> existingChunk = this.knownPartitionChunks.put(chunk.getChunkNumber(), chunk);
        if (existingChunk != null) {
            if (existingChunk.equals(chunk)) return false;
            throw new ISE("existingChunk[%s] is different from newChunk[%s] for partitionId[%d]", existingChunk, chunk, chunk.getChunkNumber());
        }
        AtomicUpdateGroup<T> atomicUpdateGroup = this.findAtomicUpdateGroupWith(chunk, State.OVERSHADOWED);
        if (atomicUpdateGroup != null) {
            atomicUpdateGroup.add(chunk);
            this.determineVisibleGroupAfterAdd(atomicUpdateGroup, State.OVERSHADOWED);
            return true;
        } else {
            atomicUpdateGroup = this.findAtomicUpdateGroupWith(chunk, State.STANDBY);
            if (atomicUpdateGroup != null) {
                atomicUpdateGroup.add(chunk);
                this.determineVisibleGroupAfterAdd(atomicUpdateGroup, State.STANDBY);
                return true;
            } else {
                atomicUpdateGroup = this.findAtomicUpdateGroupWith(chunk, State.VISIBLE);
                if (atomicUpdateGroup != null) {
                    if (atomicUpdateGroup.findChunk(chunk.getChunkNumber()) != null) throw new ISE("WTH? chunk[%s] is in the atomicUpdateGroup[%s] but not in knownPartitionChunks[%s]?", chunk, atomicUpdateGroup, this.knownPartitionChunks);
                    if (atomicUpdateGroup.isFull()) throw new ISE("Can't add chunk[%s] to a full atomicUpdateGroup[%s]", chunk, atomicUpdateGroup);
                    atomicUpdateGroup.add(chunk);
                    return true;
                } else {
                    AtomicUpdateGroup newAtomicUpdateGroup = new AtomicUpdateGroup(chunk);
                    boolean overshadowed = this.visibleGroup.values().stream().flatMap(map -> map.values().stream()).anyMatch(group -> group.overshadows(newAtomicUpdateGroup));
                    if (overshadowed) {
                        this.addAtomicUpdateGroupWithState(newAtomicUpdateGroup, State.OVERSHADOWED, true);
                        return true;
                    } else {
                        this.addAtomicUpdateGroupWithState(newAtomicUpdateGroup, State.STANDBY, true);
                    }
                }
            }
        }
        return true;
    }

    private void determineVisibleGroupAfterRemove(AtomicUpdateGroup<T> augOfRemovedChunk, RootPartitionRange rangeOfAug, short minorVersion, State stateOfRemovedAug) {
        if (stateOfRemovedAug == State.VISIBLE) {
            List<AtomicUpdateGroup<T>> latestFullAugs = this.findLatestFullyAvailableOvershadowedAtomicUpdateGroups(rangeOfAug, minorVersion);
            if (!latestFullAugs.isEmpty()) {
                Set<AtomicUpdateGroup<T>> overshadowsLatestFullAugsInVisible = latestFullAugs.stream().flatMap(group -> this.findOvershadows((AtomicUpdateGroup<T>)group, State.VISIBLE).stream()).collect(Collectors.toSet());
                this.replaceVisibleWith(overshadowsLatestFullAugsInVisible, State.STANDBY, latestFullAugs, State.OVERSHADOWED);
                latestFullAugs.stream().flatMap(group -> this.findOvershadows((AtomicUpdateGroup<T>)group, State.OVERSHADOWED).stream()).collect(Collectors.toSet()).forEach(group -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)group, State.OVERSHADOWED, State.STANDBY));
            } else {
                List<AtomicUpdateGroup<AtomicUpdateGroup>> latestOvershadowed;
                List<AtomicUpdateGroup<T>> latestStandby = this.findLatestNonFullyAvailableAtomicUpdateGroups(this.findOvershadows(rangeOfAug, minorVersion, State.STANDBY));
                if (!latestStandby.isEmpty()) {
                    List<AtomicUpdateGroup<T>> overshadowedByLatestStandby = latestStandby.stream().flatMap(group -> this.findOvershadowedBy((AtomicUpdateGroup<T>)group, State.VISIBLE).stream()).collect(Collectors.toList());
                    this.replaceVisibleWith(overshadowedByLatestStandby, State.OVERSHADOWED, latestStandby, State.STANDBY);
                    latestStandby.stream().flatMap(group -> this.findOvershadowedBy((AtomicUpdateGroup<T>)group, State.STANDBY).stream()).collect(Collectors.toSet()).forEach(aug -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)aug, State.STANDBY, State.OVERSHADOWED));
                } else if (augOfRemovedChunk.isEmpty() && !(latestOvershadowed = this.findLatestNonFullyAvailableAtomicUpdateGroups(this.findOvershadowedBy(rangeOfAug, minorVersion, State.OVERSHADOWED))).isEmpty()) {
                    latestOvershadowed.forEach(aug -> this.transitAtomicUpdateGroupState((AtomicUpdateGroup<T>)aug, State.OVERSHADOWED, State.VISIBLE));
                }
            }
        }
    }

    private List<AtomicUpdateGroup<T>> findLatestNonFullyAvailableAtomicUpdateGroups(List<AtomicUpdateGroup<T>> groups) {
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        OvershadowableManager<T> manager = new OvershadowableManager<T>(groups);
        if (!manager.standbyGroups.isEmpty()) {
            throw new ISE("This method should be called only when there is no fully available group in the given state.", new Object[0]);
        }
        ArrayList<AtomicUpdateGroup<T>> visibles = new ArrayList<AtomicUpdateGroup<T>>();
        for (Short2ObjectSortedMap<AtomicUpdateGroup<T>> map : manager.visibleGroup.values()) {
            visibles.addAll(map.values());
        }
        return visibles;
    }

    private List<AtomicUpdateGroup<T>> findLatestFullyAvailableOvershadowedAtomicUpdateGroups(RootPartitionRange rangeOfAug, short minorVersion) {
        List<AtomicUpdateGroup<T>> overshadowedGroups = this.findOvershadowedBy(rangeOfAug, minorVersion, State.OVERSHADOWED);
        if (overshadowedGroups.isEmpty()) {
            return Collections.emptyList();
        }
        OvershadowableManager<T> manager = new OvershadowableManager<T>(overshadowedGroups);
        ArrayList<AtomicUpdateGroup<T>> visibles = new ArrayList<AtomicUpdateGroup<T>>();
        for (Short2ObjectSortedMap<AtomicUpdateGroup<T>> map : manager.visibleGroup.values()) {
            for (AtomicUpdateGroup atomicUpdateGroup : map.values()) {
                if (!atomicUpdateGroup.isFull()) {
                    return Collections.emptyList();
                }
                visibles.add(atomicUpdateGroup);
            }
        }
        RootPartitionRange foundRange = RootPartitionRange.of(((AtomicUpdateGroup)visibles.get(0)).getStartRootPartitionId(), ((AtomicUpdateGroup)visibles.get(visibles.size() - 1)).getEndRootPartitionId());
        if (!rangeOfAug.equals(foundRange)) {
            return Collections.emptyList();
        }
        return visibles;
    }

    private void removeFrom(AtomicUpdateGroup<T> aug, State state) {
        RootPartitionRange rangeKey = RootPartitionRange.of(aug);
        Short2ObjectSortedMap<AtomicUpdateGroup<T>> versionToGroup = this.getStateMap(state).get(rangeKey);
        if (versionToGroup == null) {
            throw new ISE("Unknown atomicUpdateGroup[%s] in state[%s]", new Object[]{aug, state});
        }
        AtomicUpdateGroup removed = (AtomicUpdateGroup)versionToGroup.remove(aug.getMinorVersion());
        if (removed == null) {
            throw new ISE("Unknown atomicUpdateGroup[%s] in state[%s]", new Object[]{aug, state});
        }
        if (!removed.equals(aug)) {
            throw new ISE("WTH? actually removed atomicUpdateGroup[%s] is different from the one which is supposed to be[%s]", removed, aug);
        }
        if (versionToGroup.isEmpty()) {
            this.getStateMap(state).remove(rangeKey);
        }
    }

    @Nullable
    PartitionChunk<T> removeChunk(PartitionChunk<T> partitionChunk) {
        PartitionChunk<T> knownChunk = this.knownPartitionChunks.get(partitionChunk.getChunkNumber());
        if (knownChunk == null) {
            return null;
        }
        if (!knownChunk.equals(partitionChunk)) {
            throw new ISE("WTH? Same partitionId[%d], but known partition[%s] is different from the input partition[%s]", partitionChunk.getChunkNumber(), knownChunk, partitionChunk);
        }
        AtomicUpdateGroup<T> augOfRemovedChunk = this.tryRemoveChunkFromGroupWithState(partitionChunk, State.STANDBY);
        if (augOfRemovedChunk == null && (augOfRemovedChunk = this.tryRemoveChunkFromGroupWithState(partitionChunk, State.VISIBLE)) == null && (augOfRemovedChunk = this.tryRemoveChunkFromGroupWithState(partitionChunk, State.OVERSHADOWED)) == null) {
            throw new ISE("Can't find atomicUpdateGroup for partitionChunk[%s]", partitionChunk);
        }
        return this.knownPartitionChunks.remove(partitionChunk.getChunkNumber());
    }

    public boolean isEmpty() {
        return this.visibleGroup.isEmpty();
    }

    public boolean isComplete() {
        return this.visibleGroup.values().stream().allMatch(map -> ((AtomicUpdateGroup)Iterables.getOnlyElement(map.values())).isFull());
    }

    @Nullable
    PartitionChunk<T> getChunk(int partitionId) {
        PartitionChunk<T> chunk = this.knownPartitionChunks.get(partitionId);
        if (chunk == null) {
            return null;
        }
        AtomicUpdateGroup<T> aug = this.findAtomicUpdateGroupWith(chunk, State.VISIBLE);
        if (aug == null) {
            return null;
        }
        return Preconditions.checkNotNull(aug.findChunk(partitionId), "Can't find partitionChunk for partitionId[%s] in atomicUpdateGroup[%s]", partitionId, aug);
    }

    Stream<PartitionChunk<T>> createVisibleChunksStream() {
        return this.visibleGroup.values().stream().flatMap(map -> map.values().stream()).flatMap(aug -> aug.getChunks().stream());
    }

    List<PartitionChunk<T>> getOvershadowedChunks() {
        return OvershadowableManager.getAllChunks(this.overshadowedGroups);
    }

    @VisibleForTesting
    List<PartitionChunk<T>> getStandbyChunks() {
        return OvershadowableManager.getAllChunks(this.standbyGroups);
    }

    private static <T extends Overshadowable<T>> List<PartitionChunk<T>> getAllChunks(TreeMap<RootPartitionRange, Short2ObjectSortedMap<AtomicUpdateGroup<T>>> stateMap) {
        ArrayList<PartitionChunk<T>> allChunks = new ArrayList<PartitionChunk<T>>();
        for (Short2ObjectSortedMap<AtomicUpdateGroup<T>> treeMap : stateMap.values()) {
            for (AtomicUpdateGroup aug : treeMap.values()) {
                allChunks.addAll(aug.getChunks());
            }
        }
        return allChunks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OvershadowableManager that = (OvershadowableManager)o;
        return Objects.equals(this.knownPartitionChunks, that.knownPartitionChunks) && Objects.equals(this.standbyGroups, that.standbyGroups) && Objects.equals(this.visibleGroup, that.visibleGroup) && Objects.equals(this.overshadowedGroups, that.overshadowedGroups);
    }

    public int hashCode() {
        return Objects.hash(this.knownPartitionChunks, this.standbyGroups, this.visibleGroup, this.overshadowedGroups);
    }

    public String toString() {
        return "OvershadowableManager{knownPartitionChunks=" + this.knownPartitionChunks + ", standbyGroups=" + this.standbyGroups + ", visibleGroup=" + this.visibleGroup + ", overshadowedGroups=" + this.overshadowedGroups + '}';
    }

    private static class SingleEntryShort2ObjectSortedMap<V>
    extends AbstractShort2ObjectSortedMap<V> {
        private short key = (short)-1;
        private V val = null;

        private SingleEntryShort2ObjectSortedMap() {
        }

        @Override
        public Short2ObjectSortedMap<V> subMap(short fromKey, short toKey) {
            if (fromKey <= this.key && toKey > this.key) {
                return this;
            }
            throw new IAE("fromKey: %s, toKey: %s, key: %s", fromKey, toKey, this.key);
        }

        @Override
        public Short2ObjectSortedMap<V> headMap(short toKey) {
            if (toKey > this.key) {
                return this;
            }
            throw new IAE("toKey: %s, key: %s", toKey, this.key);
        }

        @Override
        public Short2ObjectSortedMap<V> tailMap(short fromKey) {
            if (fromKey <= this.key) {
                return this;
            }
            throw new IAE("fromKey: %s, key: %s", fromKey, this.key);
        }

        @Override
        public short firstShortKey() {
            if (this.key < 0) {
                throw new NoSuchElementException();
            }
            return this.key;
        }

        @Override
        public short lastShortKey() {
            if (this.key < 0) {
                throw new NoSuchElementException();
            }
            return this.key;
        }

        @Override
        public ObjectSortedSet<Short2ObjectMap.Entry<V>> short2ObjectEntrySet() {
            return this.isEmpty() ? ObjectSortedSets.EMPTY_SET : ObjectSortedSets.singleton(new AbstractShort2ObjectMap.BasicEntry<V>(this.key, this.val));
        }

        @Override
        public ShortSortedSet keySet() {
            return this.isEmpty() ? ShortSortedSets.EMPTY_SET : ShortSortedSets.singleton(this.key);
        }

        @Override
        public ObjectCollection<V> values() {
            return new AbstractObjectCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return this.size() > 0 ? ObjectIterators.singleton(val) : ObjectIterators.emptyIterator();
                }

                @Override
                public int size() {
                    return key < 0 ? 0 : 1;
                }
            };
        }

        @Override
        public V put(short key, V value) {
            if (this.isEmpty()) {
                this.key = key;
                this.val = value;
                return null;
            }
            if (this.key == key) {
                V existing = this.val;
                this.val = value;
                return existing;
            }
            throw new ISE("Can't add [%d, %s] to non-empty SingleEntryShort2ObjectSortedMap[%d, %s]", key, value, this.key, this.val);
        }

        @Override
        public V get(short key) {
            return this.key == key ? (V)this.val : null;
        }

        @Override
        public V remove(short key) {
            if (this.key == key) {
                this.key = (short)-1;
                return this.val;
            }
            return null;
        }

        @Override
        public boolean containsKey(short key) {
            return this.key == key;
        }

        @Override
        public ShortComparator comparator() {
            return ShortComparators.NATURAL_COMPARATOR;
        }

        @Override
        public int size() {
            return this.key < 0 ? 0 : 1;
        }

        @Override
        public void defaultReturnValue(V rv) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V defaultReturnValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.key < 0;
        }

        @Override
        public boolean containsValue(Object value) {
            if (this.key < 0) {
                return false;
            }
            return Objects.equals(this.val, value);
        }

        @Override
        public void putAll(Map<? extends Short, ? extends V> m) {
            if (!m.isEmpty()) {
                if (m.size() == 1) {
                    Map.Entry<Short, V> entry = m.entrySet().iterator().next();
                    this.key = entry.getKey();
                    this.val = entry.getValue();
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    @VisibleForTesting
    static class RootPartitionRange
    implements Comparable<RootPartitionRange> {
        private final short startPartitionId;
        private final short endPartitionId;

        @VisibleForTesting
        static RootPartitionRange of(int startPartitionId, int endPartitionId) {
            return new RootPartitionRange((short)startPartitionId, (short)endPartitionId);
        }

        private static <T extends Overshadowable<T>> RootPartitionRange of(PartitionChunk<T> chunk) {
            return RootPartitionRange.of(((Overshadowable)chunk.getObject()).getStartRootPartitionId(), ((Overshadowable)chunk.getObject()).getEndRootPartitionId());
        }

        private static <T extends Overshadowable<T>> RootPartitionRange of(AtomicUpdateGroup<T> aug) {
            return RootPartitionRange.of(aug.getStartRootPartitionId(), aug.getEndRootPartitionId());
        }

        private RootPartitionRange(short startPartitionId, short endPartitionId) {
            this.startPartitionId = startPartitionId;
            this.endPartitionId = endPartitionId;
        }

        public boolean contains(RootPartitionRange that) {
            return Short.toUnsignedInt(this.startPartitionId) <= Short.toUnsignedInt(that.startPartitionId) && Short.toUnsignedInt(this.endPartitionId) >= Short.toUnsignedInt(that.endPartitionId);
        }

        public boolean overlaps(RootPartitionRange that) {
            return Short.toUnsignedInt(this.startPartitionId) <= Short.toUnsignedInt(that.startPartitionId) && Short.toUnsignedInt(this.endPartitionId) > Short.toUnsignedInt(that.startPartitionId) || Short.toUnsignedInt(this.startPartitionId) >= Short.toUnsignedInt(that.startPartitionId) && Short.toUnsignedInt(this.startPartitionId) < Short.toUnsignedInt(that.endPartitionId);
        }

        @Override
        public int compareTo(RootPartitionRange o) {
            if (this.startPartitionId != o.startPartitionId) {
                return Integer.compare(Short.toUnsignedInt(this.startPartitionId), Short.toUnsignedInt(o.startPartitionId));
            }
            return Integer.compare(Short.toUnsignedInt(this.endPartitionId), Short.toUnsignedInt(o.endPartitionId));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RootPartitionRange that = (RootPartitionRange)o;
            return this.startPartitionId == that.startPartitionId && this.endPartitionId == that.endPartitionId;
        }

        public int hashCode() {
            return Objects.hash(this.startPartitionId, this.endPartitionId);
        }

        public String toString() {
            return "RootPartitionRange{startPartitionId=" + this.startPartitionId + ", endPartitionId=" + this.endPartitionId + '}';
        }
    }

    @VisibleForTesting
    static enum State {
        STANDBY,
        VISIBLE,
        OVERSHADOWED;

    }
}

