/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;

public class LinearPartitionChunk<T>
implements PartitionChunk<T> {
    private final int chunkNumber;
    private final T object;

    public LinearPartitionChunk(int chunkNumber, T object) {
        this.chunkNumber = chunkNumber;
        this.object = object;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public boolean abuts(PartitionChunk<T> chunk) {
        return true;
    }

    @Override
    public boolean isStart() {
        return true;
    }

    @Override
    public boolean isEnd() {
        return true;
    }

    @Override
    public int getChunkNumber() {
        return this.chunkNumber;
    }

    @Override
    public int compareTo(PartitionChunk<T> chunk) {
        if (chunk instanceof LinearPartitionChunk) {
            LinearPartitionChunk linearChunk = (LinearPartitionChunk)chunk;
            return Integer.compare(this.chunkNumber, linearChunk.chunkNumber);
        }
        throw new IllegalArgumentException("Cannot compare against something that is not a LinearPartitionChunk.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((LinearPartitionChunk)o) == 0;
    }

    public int hashCode() {
        return this.chunkNumber;
    }
}

