/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import org.apache.hive.druid.org.apache.druid.timeline.Overshadowable;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;

public class IntegerPartitionChunk<T extends Overshadowable>
implements PartitionChunk<T> {
    private final Integer start;
    private final Integer end;
    private final int chunkNumber;
    private final T object;

    public static <T extends Overshadowable> IntegerPartitionChunk<T> make(Integer start, Integer end, int chunkNumber, T obj) {
        return new IntegerPartitionChunk<T>(start, end, chunkNumber, obj);
    }

    public IntegerPartitionChunk(Integer start, Integer end, int chunkNumber, T object) {
        this.start = start;
        this.end = end;
        this.chunkNumber = chunkNumber;
        this.object = object;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public boolean abuts(PartitionChunk<T> chunk) {
        if (chunk instanceof IntegerPartitionChunk) {
            IntegerPartitionChunk intChunk = (IntegerPartitionChunk)chunk;
            if (intChunk.isStart()) {
                return false;
            }
            return intChunk.start.equals(this.end);
        }
        return false;
    }

    @Override
    public boolean isStart() {
        return this.start == null;
    }

    @Override
    public boolean isEnd() {
        return this.end == null;
    }

    @Override
    public int getChunkNumber() {
        return this.chunkNumber;
    }

    @Override
    public int compareTo(PartitionChunk<T> chunk) {
        if (chunk instanceof IntegerPartitionChunk) {
            IntegerPartitionChunk intChunk = (IntegerPartitionChunk)chunk;
            return Integer.compare(this.chunkNumber, intChunk.chunkNumber);
        }
        throw new IllegalArgumentException("Cannot compare against something that is not an IntegerPartitionChunk.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((IntegerPartitionChunk)o) == 0;
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IntegerPartitionChunk{start=" + this.start + ", end=" + this.end + ", object=" + this.object + '}';
    }
}

