/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline;

import java.util.Objects;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.org.apache.druid.timeline.LogicalSegment;
import org.apache.hive.druid.org.apache.druid.timeline.Overshadowable;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;

public class TimelineObjectHolder<VersionType, ObjectType extends Overshadowable<ObjectType>>
implements LogicalSegment {
    private final Interval interval;
    private final Interval trueInterval;
    private final VersionType version;
    private final PartitionHolder<ObjectType> object;

    @VisibleForTesting
    public TimelineObjectHolder(Interval interval, VersionType version, PartitionHolder<ObjectType> object) {
        this(interval, interval, version, object);
    }

    public TimelineObjectHolder(Interval interval, Interval trueInterval, VersionType version, PartitionHolder<ObjectType> object) {
        this.interval = interval;
        this.trueInterval = trueInterval;
        this.version = version;
        this.object = object;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public Interval getTrueInterval() {
        return this.trueInterval;
    }

    public VersionType getVersion() {
        return this.version;
    }

    public PartitionHolder<ObjectType> getObject() {
        return this.object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineObjectHolder that = (TimelineObjectHolder)o;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.version, that.version) && Objects.equals(this.object, that.object);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.version, this.object);
    }

    public String toString() {
        return "TimelineObjectHolder{interval=" + this.interval + ", trueInterval=" + this.trueInterval + ", version=" + this.version + ", object=" + this.object + '}';
    }
}

