/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.storage.hdfs.tasklog;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.org.apache.druid.guice.Hdfs;
import org.apache.hive.druid.org.apache.druid.java.util.common.IOE;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.tasklog.HdfsTaskLogsConfig;
import org.apache.hive.druid.org.apache.druid.tasklogs.TaskLogs;

public class HdfsTaskLogs
implements TaskLogs {
    private static final Logger log = new Logger(HdfsTaskLogs.class);
    private final HdfsTaskLogsConfig config;
    private final Configuration hadoopConfig;

    @Inject
    public HdfsTaskLogs(HdfsTaskLogsConfig config, @Hdfs Configuration hadoopConfig) {
        this.config = config;
        this.hadoopConfig = hadoopConfig;
    }

    @Override
    public void pushTaskLog(String taskId, File logFile) throws IOException {
        Path path = this.getTaskLogFileFromId(taskId);
        log.info("Writing task log to: %s", path);
        this.pushTaskFile(path, logFile);
        log.info("Wrote task log to: %s", path);
    }

    @Override
    public void pushTaskReports(String taskId, File reportFile) throws IOException {
        Path path = this.getTaskReportsFileFromId(taskId);
        log.info("Writing task reports to: %s", path);
        this.pushTaskFile(path, reportFile);
        log.info("Wrote task reports to: %s", path);
    }

    private void pushTaskFile(Path path, File logFile) throws IOException {
        FileSystem fs = path.getFileSystem(this.hadoopConfig);
        try (FileInputStream in = new FileInputStream(logFile);
             FSDataOutputStream out = fs.create(path, true);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
    }

    @Override
    public Optional<ByteSource> streamTaskLog(String taskId, long offset) throws IOException {
        Path path = this.getTaskLogFileFromId(taskId);
        return this.streamTaskFile(path, offset);
    }

    @Override
    public Optional<ByteSource> streamTaskReports(String taskId) throws IOException {
        Path path = this.getTaskReportsFileFromId(taskId);
        return this.streamTaskFile(path, 0L);
    }

    private Optional<ByteSource> streamTaskFile(final Path path, final long offset) throws IOException {
        final FileSystem fs = path.getFileSystem(this.hadoopConfig);
        if (fs.exists(path)) {
            return Optional.of(new ByteSource(){

                @Override
                public InputStream openStream() throws IOException {
                    long seekPos;
                    log.info("Reading task log from: %s", path);
                    if (offset < 0L) {
                        FileStatus stat = fs.getFileStatus(path);
                        seekPos = Math.max(0L, stat.getLen() + offset);
                    } else {
                        seekPos = offset;
                    }
                    FSDataInputStream inputStream = fs.open(path);
                    inputStream.seek(seekPos);
                    log.info("Read task log from: %s (seek = %,d)", path, seekPos);
                    return inputStream;
                }
            });
        }
        return Optional.absent();
    }

    private Path getTaskLogFileFromId(String taskId) {
        return new Path(HdfsTaskLogs.mergePaths(this.config.getDirectory(), taskId.replace(':', '_')));
    }

    private Path getTaskReportsFileFromId(String taskId) {
        return new Path(HdfsTaskLogs.mergePaths(this.config.getDirectory(), taskId.replace(':', '_') + ".reports.json"));
    }

    private static String mergePaths(String path1, String path2) {
        return path1 + (path1.endsWith("/") ? "" : "/") + path2;
    }

    @Override
    public void killAll() throws IOException {
        log.info("Deleting all task logs from hdfs dir [%s].", this.config.getDirectory());
        Path taskLogDir = new Path(this.config.getDirectory());
        FileSystem fs = taskLogDir.getFileSystem(this.hadoopConfig);
        fs.delete(taskLogDir, true);
    }

    @Override
    public void killOlderThan(long timestamp) throws IOException {
        Path taskLogDir = new Path(this.config.getDirectory());
        FileSystem fs = taskLogDir.getFileSystem(this.hadoopConfig);
        if (fs.exists(taskLogDir)) {
            if (!fs.isDirectory(taskLogDir)) {
                throw new IOE("taskLogDir [%s] must be a directory.", taskLogDir);
            }
            RemoteIterator iter = fs.listLocatedStatus(taskLogDir);
            while (iter.hasNext()) {
                LocatedFileStatus file = (LocatedFileStatus)iter.next();
                if (file.getModificationTime() < timestamp) {
                    Path p = file.getPath();
                    log.info("Deleting hdfs task log [%s].", p.toUri().toString());
                    fs.delete(p, true);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new IOException(new InterruptedException("Thread interrupted. Couldn't delete all tasklogs."));
            }
        }
    }
}

