/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.org.apache.druid.guice.Hdfs;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsKerberosConfig;

@ManageLifecycle
public class HdfsStorageAuthentication {
    private static final Logger log = new Logger(HdfsStorageAuthentication.class);
    private final HdfsKerberosConfig hdfsKerberosConfig;
    private final Configuration hadoopConf;

    @Inject
    public HdfsStorageAuthentication(HdfsKerberosConfig hdfsKerberosConfig, @Hdfs Configuration hadoopConf) {
        this.hdfsKerberosConfig = hdfsKerberosConfig;
        this.hadoopConf = hadoopConf;
    }

    @LifecycleStart
    public void authenticate() {
        String principal = this.hdfsKerberosConfig.getPrincipal();
        String keytab = this.hdfsKerberosConfig.getKeytab();
        if (!Strings.isNullOrEmpty(principal) && !Strings.isNullOrEmpty(keytab)) {
            UserGroupInformation.setConfiguration((Configuration)this.hadoopConf);
            if (UserGroupInformation.isSecurityEnabled()) {
                try {
                    if (!UserGroupInformation.getCurrentUser().hasKerberosCredentials() || !UserGroupInformation.getCurrentUser().getUserName().equals(principal)) {
                        log.info("Trying to authenticate user [%s] with keytab [%s]..", principal, keytab);
                        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                    }
                }
                catch (IOException e) {
                    throw new ISE(e, "Failed to authenticate user principal [%s] with keytab [%s]", principal, keytab);
                }
            }
        }
    }

    @LifecycleStop
    public void stop() {
    }
}

