/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.org.apache.druid.server.security.AuthenticationResult;

public class AllowOptionsResourceFilter
implements Filter {
    private final boolean allowUnauthenticatedHttpOptions;

    public AllowOptionsResourceFilter(boolean allowUnauthenticatedHttpOptions) {
        this.allowUnauthenticatedHttpOptions = allowUnauthenticatedHttpOptions;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        if ("OPTIONS".equals(httpReq.getMethod())) {
            if (httpReq.getAttribute("Druid-Authentication-Result") == null) {
                if (this.allowUnauthenticatedHttpOptions) {
                    httpReq.setAttribute("Druid-Authentication-Result", (Object)new AuthenticationResult("allowAll", "allowAll", null, null));
                } else {
                    ((HttpServletResponse)response).sendError(401);
                }
            }
            httpReq.setAttribute("Druid-Authorization-Checked", (Object)true);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

