/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.router;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.hash.HashCode;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hashing;

public class RendezvousHasher {
    private static final HashFunction HASH_FN = Hashing.murmur3_128();

    public <KeyType> String chooseNode(Set<String> nodeIds, byte[] key) {
        if (nodeIds.isEmpty()) {
            return null;
        }
        HashCode keyHash = HASH_FN.hashBytes(key);
        long maxHash = Long.MIN_VALUE;
        String maxNode = null;
        for (String nodeId : nodeIds) {
            HashCode nodeHash = HASH_FN.hashString(nodeId, StandardCharsets.UTF_8);
            ArrayList<HashCode> hashes = Lists.newArrayList(nodeHash, keyHash);
            long combinedHash = Hashing.combineOrdered(hashes).asLong();
            if (maxNode == null) {
                maxHash = combinedHash;
                maxNode = nodeId;
                continue;
            }
            if (combinedHash <= maxHash) continue;
            maxHash = combinedHash;
            maxNode = nodeId;
        }
        return maxNode;
    }
}

