/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.org.apache.druid.server.RequestLogLine;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLogger;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class FileRequestLogger
implements RequestLogger {
    private final ObjectMapper objectMapper;
    private final ScheduledExecutorService exec;
    private final File baseDir;
    private final DateTimeFormatter filePattern;
    private final Object lock = new Object();
    private DateTime currentDay;
    private OutputStreamWriter fileWriter;

    public FileRequestLogger(ObjectMapper objectMapper, ScheduledExecutorService exec, File baseDir, String filePattern) {
        this.exec = exec;
        this.objectMapper = objectMapper;
        this.baseDir = baseDir;
        this.filePattern = DateTimeFormat.forPattern((String)filePattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        try {
            this.baseDir.mkdirs();
            MutableDateTime mutableDateTime = DateTimes.nowUtc().toMutableDateTime((Chronology)ISOChronology.getInstanceUTC());
            mutableDateTime.setMillisOfDay(0);
            Object object = this.lock;
            synchronized (object) {
                this.currentDay = mutableDateTime.toDateTime((Chronology)ISOChronology.getInstanceUTC());
                this.fileWriter = this.getFileWriter();
            }
            long nextDay = this.currentDay.plusDays(1).getMillis();
            Duration initialDelay = new Duration(nextDay - System.currentTimeMillis());
            ScheduledExecutors.scheduleWithFixedDelay(this.exec, initialDelay, Duration.standardDays((long)1L), new Callable<ScheduledExecutors.Signal>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ScheduledExecutors.Signal call() {
                    try {
                        Object object = FileRequestLogger.this.lock;
                        synchronized (object) {
                            FileRequestLogger.this.currentDay = FileRequestLogger.this.currentDay.plusDays(1);
                            CloseQuietly.close(FileRequestLogger.this.fileWriter);
                            FileRequestLogger.this.fileWriter = FileRequestLogger.this.getFileWriter();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return ScheduledExecutors.Signal.REPEAT;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private OutputStreamWriter getFileWriter() throws FileNotFoundException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.baseDir, this.filePattern.print((ReadableInstant)this.currentDay)), true), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            CloseQuietly.close(this.fileWriter);
        }
    }

    @Override
    public void logNativeQuery(RequestLogLine requestLogLine) throws IOException {
        this.logToFile(requestLogLine.getNativeQueryLine(this.objectMapper));
    }

    @Override
    public void logSqlQuery(RequestLogLine requestLogLine) throws IOException {
        this.logToFile(requestLogLine.getSqlQueryLine(this.objectMapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToFile(String message) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.fileWriter.write(message);
            this.fileWriter.write("\n");
            this.fileWriter.flush();
        }
    }

    public String toString() {
        return "FileRequestLogger{baseDir=" + this.baseDir + '}';
    }
}

