/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.listener.resource;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.org.apache.druid.common.utils.ServletResourceUtils;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.server.listener.resource.ListenerHandler;

public abstract class ListenerResource {
    public static final String BASE_PATH = "/druid/listen/v1";
    private static final Logger LOG = new Logger(ListenerResource.class);
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final ListenerHandler handler;

    public ListenerResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, ListenerHandler handler) {
        this.jsonMapper = Preconditions.checkNotNull(jsonMapper, "jsonMapper");
        this.smileMapper = Preconditions.checkNotNull(smileMapper, "smileMapper");
        this.handler = Preconditions.checkNotNull(handler, "listener handler");
    }

    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public Response serviceAnnouncementPOSTAll(InputStream inputStream, @Context HttpServletRequest req) {
        String reqContentType = req.getContentType();
        boolean isSmile = "application/x-jackson-smile".equals(reqContentType);
        ObjectMapper mapper = isSmile ? this.smileMapper : this.jsonMapper;
        try {
            return this.handler.handlePOSTAll(inputStream, mapper);
        }
        catch (Exception e) {
            LOG.error(e, "Exception in handling POSTAll request", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @POST
    @Path(value="/updates")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public Response serviceAnnouncementHandleUpdates(InputStream inputStream, @Context HttpServletRequest req) {
        String reqContentType = req.getContentType();
        boolean isSmile = "application/x-jackson-smile".equals(reqContentType);
        ObjectMapper mapper = isSmile ? this.smileMapper : this.jsonMapper;
        try {
            return this.handler.handleUpdates(inputStream, mapper);
        }
        catch (Exception e) {
            LOG.error(e, "Exception in handling updates request", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Response getAll() {
        try {
            return this.handler.handleGETAll();
        }
        catch (Exception e) {
            LOG.error(e, "Exception in handling GETAll request", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @Path(value="/{id}")
    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Response serviceAnnouncementGET(@PathParam(value="id") String id) {
        if (Strings.isNullOrEmpty(id)) {
            return ListenerResource.makeNullIdResponse();
        }
        try {
            return this.handler.handleGET(id);
        }
        catch (Exception e) {
            LOG.error(e, "Exception in handling GET request for [%s]", id);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @Path(value="/{id}")
    @DELETE
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Response serviceAnnouncementDELETE(@PathParam(value="id") String id) {
        if (Strings.isNullOrEmpty(id)) {
            return ListenerResource.makeNullIdResponse();
        }
        try {
            return this.handler.handleDELETE(id);
        }
        catch (Exception e) {
            LOG.error(e, "Exception in handling DELETE request for [%s]", id);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @Path(value="/{id}")
    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Response serviceAnnouncementPOST(@PathParam(value="id") String id, InputStream inputStream, @Context HttpServletRequest req) {
        if (Strings.isNullOrEmpty(id)) {
            return ListenerResource.makeNullIdResponse();
        }
        String reqContentType = req.getContentType();
        boolean isSmile = "application/x-jackson-smile".equals(reqContentType);
        ObjectMapper mapper = isSmile ? this.smileMapper : this.jsonMapper;
        try {
            return this.handler.handlePOST(inputStream, mapper, id);
        }
        catch (Exception e) {
            LOG.error(e, "Exception in handling POST request for ID [%s]", id);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    public static Response makeNullIdResponse() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new IllegalArgumentException("Cannot have null or empty id"))).build();
    }
}

