/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http.security;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import javax.ws.rs.core.PathSegment;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.server.http.security.AbstractResourceFilter;
import org.apache.hive.druid.org.apache.druid.server.security.Access;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizationUtils;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.org.apache.druid.server.security.ForbiddenException;
import org.apache.hive.druid.org.apache.druid.server.security.Resource;
import org.apache.hive.druid.org.apache.druid.server.security.ResourceAction;
import org.apache.hive.druid.org.apache.druid.server.security.ResourceType;

public class DatasourceResourceFilter
extends AbstractResourceFilter {
    @Inject
    public DatasourceResourceFilter(AuthorizerMapper authorizerMapper) {
        super(authorizerMapper);
    }

    public ContainerRequest filter(ContainerRequest request) {
        ResourceAction resourceAction = new ResourceAction(new Resource(this.getRequestDatasourceName(request), ResourceType.DATASOURCE), this.getAction(request));
        Access authResult = AuthorizationUtils.authorizeResourceAction(this.getReq(), resourceAction, this.getAuthorizerMapper());
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        return request;
    }

    private String getRequestDatasourceName(ContainerRequest request) {
        String dataSourceName = ((PathSegment)request.getPathSegments().get(Iterables.indexOf(request.getPathSegments(), new Predicate<PathSegment>(){

            @Override
            public boolean apply(PathSegment input) {
                return "datasources".equals(input.getPath());
            }
        }) + 1)).getPath();
        Preconditions.checkNotNull(dataSourceName);
        return dataSourceName;
    }
}

