/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.org.apache.druid.audit.AuditInfo;
import org.apache.hive.druid.org.apache.druid.common.utils.ServletResourceUtils;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.RE;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupsState;
import org.apache.hive.druid.org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.hive.druid.org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.hive.druid.org.apache.druid.server.lookup.cache.LookupExtractorFactoryMapContainer;

@Path(value="/druid/coordinator/v1/lookups")
@ResourceFilters(value={ConfigResourceFilter.class})
public class LookupCoordinatorResource {
    private static final Logger LOG = new Logger(LookupCoordinatorResource.class);
    private final LookupCoordinatorManager lookupCoordinatorManager;
    private final ObjectMapper smileMapper;
    private final ObjectMapper jsonMapper;

    @Inject
    public LookupCoordinatorResource(LookupCoordinatorManager lookupCoordinatorManager, @Smile ObjectMapper smileMapper, @Json ObjectMapper jsonMapper) {
        this.smileMapper = smileMapper;
        this.jsonMapper = jsonMapper;
        this.lookupCoordinatorManager = lookupCoordinatorManager;
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Response getTiers(@DefaultValue(value="false") @QueryParam(value="discover") boolean discover) {
        try {
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> knownLookups = this.lookupCoordinatorManager.getKnownLookups();
            if (discover) {
                HashSet<String> discovered = new HashSet<String>(this.lookupCoordinatorManager.discoverTiers());
                if (knownLookups != null) {
                    discovered.addAll(knownLookups.keySet());
                }
                return Response.ok().entity(discovered).build();
            }
            if (knownLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok().entity(knownLookups.keySet()).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error getting list of lookups", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/config/all")
    public Response getAllLookupSpecs() {
        try {
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> knownLookups = this.lookupCoordinatorManager.getKnownLookups();
            if (knownLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok().entity(knownLookups).build();
        }
        catch (Exception ex) {
            LOG.error(ex, "Error getting lookups status", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(ex)).build();
        }
    }

    @POST
    @Path(value="/config")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public Response updateAllLookups(InputStream in, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        try {
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> map;
            boolean isSmile = "application/x-jackson-smile".equals(req.getContentType());
            ObjectMapper mapper = isSmile ? this.smileMapper : this.jsonMapper;
            try {
                map = mapper.readValue(in, new TypeReference<Map<String, Map<String, LookupExtractorFactoryMapContainer>>>(){});
            }
            catch (IOException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(e)).build();
            }
            if (this.lookupCoordinatorManager.updateLookups(map, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity(map).build();
            }
            throw new RuntimeException("Unknown error updating configuration");
        }
        catch (Exception e) {
            LOG.error(e, "Error creating new lookups", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @DELETE
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/config/{tier}")
    public Response deleteTier(@PathParam(value="tier") String tier, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        try {
            if (Strings.isNullOrEmpty(tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`tier` required"))).build();
            }
            if (this.lookupCoordinatorManager.deleteTier(tier, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error deleting tier [%s]", tier);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @DELETE
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/config/{tier}/{lookup}")
    public Response deleteLookup(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        try {
            if (Strings.isNullOrEmpty(tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`tier` required"))).build();
            }
            if (Strings.isNullOrEmpty(lookup)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new IAE("`lookup` required", new Object[0]))).build();
            }
            if (this.lookupCoordinatorManager.deleteLookup(tier, lookup, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error deleting lookup [%s]", lookup);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/config/{tier}/{lookup}")
    public Response createOrUpdateLookup(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, InputStream in, @Context HttpServletRequest req) {
        try {
            LookupExtractorFactoryMapContainer lookupSpec;
            if (Strings.isNullOrEmpty(tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`tier` required"))).build();
            }
            if (Strings.isNullOrEmpty(lookup)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new IAE("`lookup` required", new Object[0]))).build();
            }
            boolean isSmile = "application/x-jackson-smile".equals(req.getContentType());
            ObjectMapper mapper = isSmile ? this.smileMapper : this.jsonMapper;
            try {
                lookupSpec = mapper.readValue(in, LookupExtractorFactoryMapContainer.class);
            }
            catch (IOException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(e)).build();
            }
            if (this.lookupCoordinatorManager.updateLookup(tier, lookup, lookupSpec, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            throw new RuntimeException("Unknown error updating configuration");
        }
        catch (Exception e) {
            LOG.error(e, "Error updating tier [%s] lookup [%s]", tier, lookup);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/config/{tier}/{lookup}")
    public Response getSpecificLookup(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup) {
        try {
            if (Strings.isNullOrEmpty(tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`tier` required"))).build();
            }
            if (Strings.isNullOrEmpty(lookup)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`lookup` required"))).build();
            }
            LookupExtractorFactoryMapContainer map = this.lookupCoordinatorManager.getLookup(tier, lookup);
            if (map == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.sanitizeException(new RE("lookup [%s] not found", lookup))).build();
            }
            return Response.ok().entity((Object)map).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error getting lookup [%s]", lookup);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/config/{tier}")
    public Response getSpecificTier(@PathParam(value="tier") String tier, @DefaultValue(value="false") @QueryParam(value="detailed") boolean detailed) {
        try {
            if (Strings.isNullOrEmpty(tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`tier` required"))).build();
            }
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> map = this.lookupCoordinatorManager.getKnownLookups();
            if (map == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.sanitizeException(new RE("No lookups found", new Object[0]))).build();
            }
            Map<String, LookupExtractorFactoryMapContainer> tierLookups = map.get(tier);
            if (tierLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.sanitizeException(new RE("Tier [%s] not found", tier))).build();
            }
            if (detailed) {
                return Response.ok().entity(tierLookups).build();
            }
            return Response.ok().entity(tierLookups.keySet()).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error getting tier [%s]", tier);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/status")
    public Response getAllLookupsStatus(@QueryParam(value="detailed") boolean detailed) {
        try {
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> configuredLookups = this.lookupCoordinatorManager.getKnownLookups();
            if (configuredLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.jsonize("No lookups found", new Object[0])).build();
            }
            Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> lookupsStateOnNodes = this.lookupCoordinatorManager.getLastKnownLookupsStateOnNodes();
            HashMap result = new HashMap();
            for (Map.Entry<String, Map<String, LookupExtractorFactoryMapContainer>> tierEntry : configuredLookups.entrySet()) {
                String tier = tierEntry.getKey();
                HashMap<String, LookupStatus> lookupStatusMap = new HashMap<String, LookupStatus>();
                result.put(tier, lookupStatusMap);
                Collection<HostAndPort> hosts = this.lookupCoordinatorManager.discoverNodesInTier(tier);
                for (Map.Entry<String, LookupExtractorFactoryMapContainer> lookupsEntry : tierEntry.getValue().entrySet()) {
                    lookupStatusMap.put(lookupsEntry.getKey(), this.getLookupStatus(lookupsEntry.getKey(), lookupsEntry.getValue(), hosts, lookupsStateOnNodes, detailed));
                }
            }
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            LOG.error(ex, "Error getting lookups status", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(ex)).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/status/{tier}")
    public Response getLookupStatusForTier(@PathParam(value="tier") String tier, @QueryParam(value="detailed") boolean detailed) {
        try {
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> configuredLookups = this.lookupCoordinatorManager.getKnownLookups();
            if (configuredLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.jsonize("No lookups found", new Object[0])).build();
            }
            Map<String, LookupExtractorFactoryMapContainer> tierLookups = configuredLookups.get(tier);
            if (tierLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.jsonize("No lookups found for tier [%s].", tier)).build();
            }
            HashMap<String, LookupStatus> lookupStatusMap = new HashMap<String, LookupStatus>();
            Collection<HostAndPort> hosts = this.lookupCoordinatorManager.discoverNodesInTier(tier);
            Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> lookupsStateOnNodes = this.lookupCoordinatorManager.getLastKnownLookupsStateOnNodes();
            for (Map.Entry<String, LookupExtractorFactoryMapContainer> lookupsEntry : tierLookups.entrySet()) {
                lookupStatusMap.put(lookupsEntry.getKey(), this.getLookupStatus(lookupsEntry.getKey(), lookupsEntry.getValue(), hosts, lookupsStateOnNodes, detailed));
            }
            return Response.ok(lookupStatusMap).build();
        }
        catch (Exception ex) {
            LOG.error(ex, "Error getting lookups status for tier [%s].", tier);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(ex)).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/status/{tier}/{lookup}")
    public Response getSpecificLookupStatus(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup, @QueryParam(value="detailed") boolean detailed) {
        try {
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> configuredLookups = this.lookupCoordinatorManager.getKnownLookups();
            if (configuredLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.jsonize("No lookups found", new Object[0])).build();
            }
            Map<String, LookupExtractorFactoryMapContainer> tierLookups = configuredLookups.get(tier);
            if (tierLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.jsonize("No lookups found for tier [%s].", tier)).build();
            }
            LookupExtractorFactoryMapContainer lookupDef = tierLookups.get(lookup);
            if (lookupDef == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.jsonize("Lookup [%s] not found for tier [%s].", lookup, tier)).build();
            }
            return Response.ok((Object)this.getLookupStatus(lookup, lookupDef, this.lookupCoordinatorManager.discoverNodesInTier(tier), this.lookupCoordinatorManager.getLastKnownLookupsStateOnNodes(), detailed)).build();
        }
        catch (Exception ex) {
            LOG.error(ex, "Error getting lookups status for tier [%s] and lookup [%s].", tier, lookup);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(ex)).build();
        }
    }

    @VisibleForTesting
    LookupStatus getLookupStatus(String lookupName, LookupExtractorFactoryMapContainer lookupDef, Collection<HostAndPort> nodes, Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> lastKnownLookupsState, boolean detailed) {
        boolean isReady = true;
        ArrayList<HostAndPort> pendingHosts = detailed ? new ArrayList<HostAndPort>() : null;
        for (HostAndPort node : nodes) {
            LookupExtractorFactoryMapContainer loadedOnHost;
            LookupsState<LookupExtractorFactoryMapContainer> hostState = lastKnownLookupsState.get(node);
            LookupExtractorFactoryMapContainer lookupExtractorFactoryMapContainer = loadedOnHost = hostState != null ? hostState.getCurrent().get(lookupName) : null;
            if (loadedOnHost != null && !lookupDef.replaces(loadedOnHost)) continue;
            isReady = false;
            if (!detailed) break;
            pendingHosts.add(node);
        }
        return new LookupStatus(isReady, pendingHosts);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/nodeStatus")
    public Response getAllNodesStatus(@QueryParam(value="discover") boolean discover) {
        try {
            Set<String> tiers;
            if (discover) {
                tiers = this.lookupCoordinatorManager.discoverTiers();
            } else {
                Map<String, Map<String, LookupExtractorFactoryMapContainer>> configuredLookups = this.lookupCoordinatorManager.getKnownLookups();
                if (configuredLookups == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.jsonize("No lookups configured.", new Object[0])).build();
                }
                tiers = configuredLookups.keySet();
            }
            Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> lookupsStateOnHosts = this.lookupCoordinatorManager.getLastKnownLookupsStateOnNodes();
            HashMap result = new HashMap();
            for (String tier : tiers) {
                HashMap tierNodesStatus = new HashMap();
                result.put(tier, tierNodesStatus);
                Collection<HostAndPort> nodes = this.lookupCoordinatorManager.discoverNodesInTier(tier);
                for (HostAndPort node : nodes) {
                    LookupsState<LookupExtractorFactoryMapContainer> lookupsState = lookupsStateOnHosts.get(node);
                    if (lookupsState == null) {
                        tierNodesStatus.put(node, new LookupsState(null, null, null));
                        continue;
                    }
                    tierNodesStatus.put(node, lookupsState);
                }
            }
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            LOG.error(ex, "Error getting node status.", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(ex)).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/nodeStatus/{tier}")
    public Response getNodesStatusInTier(@PathParam(value="tier") String tier) {
        try {
            Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> lookupsStateOnHosts = this.lookupCoordinatorManager.getLastKnownLookupsStateOnNodes();
            HashMap tierNodesStatus = new HashMap();
            Collection<HostAndPort> nodes = this.lookupCoordinatorManager.discoverNodesInTier(tier);
            for (HostAndPort node : nodes) {
                LookupsState<LookupExtractorFactoryMapContainer> lookupsState = lookupsStateOnHosts.get(node);
                if (lookupsState == null) {
                    tierNodesStatus.put(node, new LookupsState(null, null, null));
                    continue;
                }
                tierNodesStatus.put(node, lookupsState);
            }
            return Response.ok(tierNodesStatus).build();
        }
        catch (Exception ex) {
            LOG.error(ex, "Error getting node status for tier [%s].", tier);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(ex)).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/nodeStatus/{tier}/{hostAndPort}")
    public Response getSpecificNodeStatus(@PathParam(value="tier") String tier, @PathParam(value="hostAndPort") HostAndPort hostAndPort) {
        try {
            Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> lookupsStateOnHosts = this.lookupCoordinatorManager.getLastKnownLookupsStateOnNodes();
            LookupsState<LookupExtractorFactoryMapContainer> lookupsState = lookupsStateOnHosts.get(hostAndPort);
            if (lookupsState == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.jsonize("Node [%s] status is unknown.", hostAndPort)).build();
            }
            return Response.ok(lookupsState).build();
        }
        catch (Exception ex) {
            LOG.error(ex, "Error getting node status for [%s].", hostAndPort);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(ex)).build();
        }
    }

    @VisibleForTesting
    static class LookupStatus {
        @JsonProperty
        private boolean loaded;
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private List<HostAndPort> pendingNodes;

        public LookupStatus(boolean loaded, List<HostAndPort> pendingHosts) {
            this.loaded = loaded;
            this.pendingNodes = pendingHosts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupStatus that = (LookupStatus)o;
            return Objects.equals(this.loaded, that.loaded) && Objects.equals(this.pendingNodes, that.pendingNodes);
        }

        public int hashCode() {
            return Objects.hash(this.loaded, this.pendingNodes);
        }
    }
}

