/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.server.coordination.ZkCoordinator;
import org.apache.hive.druid.org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid/historical/v1")
public class HistoricalResource {
    private final ZkCoordinator coordinator;

    @Inject
    public HistoricalResource(ZkCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @GET
    @Path(value="/loadstatus")
    @ResourceFilters(value={StateResourceFilter.class})
    @Produces(value={"application/json"})
    public Response getLoadStatus() {
        return Response.ok(ImmutableMap.of("cacheInitialized", this.coordinator.isStarted())).build();
    }

    @GET
    @Path(value="/readiness")
    public Response getReadiness() {
        if (this.coordinator.isStarted()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }
}

