/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.client.CoordinatorServerView;
import org.apache.hive.druid.org.apache.druid.client.DruidDataSource;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.hive.druid.org.apache.druid.client.SegmentLoadInfo;
import org.apache.hive.druid.org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.MapUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.org.apache.druid.metadata.UnknownSegmentIdException;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.org.apache.druid.server.http.InventoryViewUtils;
import org.apache.hive.druid.org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineLookup;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@Path(value="/druid/coordinator/v1/datasources")
public class DataSourcesResource {
    private static final Logger log = new Logger(DataSourcesResource.class);
    private final CoordinatorServerView serverInventoryView;
    private final MetadataSegmentManager segmentsMetadata;
    private final MetadataRuleManager metadataRuleManager;
    private final IndexingServiceClient indexingServiceClient;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public DataSourcesResource(CoordinatorServerView serverInventoryView, MetadataSegmentManager segmentsMetadata, MetadataRuleManager metadataRuleManager, @Nullable IndexingServiceClient indexingServiceClient, AuthorizerMapper authorizerMapper) {
        this.serverInventoryView = serverInventoryView;
        this.segmentsMetadata = segmentsMetadata;
        this.metadataRuleManager = metadataRuleManager;
        this.indexingServiceClient = indexingServiceClient;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getQueryableDataSources(@QueryParam(value="full") String full, @QueryParam(value="simple") String simple, @Context HttpServletRequest req) {
        Response.ResponseBuilder builder = Response.ok();
        SortedSet<ImmutableDruidDataSource> datasources = InventoryViewUtils.getSecuredDataSources(req, this.serverInventoryView, this.authorizerMapper);
        SequencedCollection<ImmutableDruidDataSource> entity = full != null ? datasources : (simple != null ? datasources.stream().map(this::makeSimpleDatasource).collect(Collectors.toList()) : datasources.stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        return builder.entity(entity).build();
    }

    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        if (full != null) {
            return Response.ok((Object)dataSource).build();
        }
        return Response.ok(this.getSimpleDatasource(dataSourceName)).build();
    }

    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markAsUsedAllNonOvershadowedSegments(@PathParam(value="dataSourceName") String dataSourceName) {
        MarkSegments markSegments = () -> this.segmentsMetadata.markAsUsedAllNonOvershadowedSegmentsInDataSource(dataSourceName);
        return DataSourcesResource.doMarkSegments("markAsUsedAllNonOvershadowedSegments", dataSourceName, markSegments);
    }

    @POST
    @Path(value="/{dataSourceName}/markUsed")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markAsUsedNonOvershadowedSegments(@PathParam(value="dataSourceName") String dataSourceName, MarkDataSourceSegmentsPayload payload) {
        MarkSegments markSegments = () -> {
            Interval interval = payload.getInterval();
            if (interval != null) {
                return this.segmentsMetadata.markAsUsedNonOvershadowedSegmentsInInterval(dataSourceName, interval);
            }
            Set<String> segmentIds = payload.getSegmentIds();
            return this.segmentsMetadata.markAsUsedNonOvershadowedSegments(dataSourceName, segmentIds);
        };
        return this.doMarkSegmentsWithPayload("markAsUsedNonOvershadowedSegments", dataSourceName, payload, markSegments);
    }

    @POST
    @Path(value="/{dataSourceName}/markUnused")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response markSegmentsAsUnused(@PathParam(value="dataSourceName") String dataSourceName, MarkDataSourceSegmentsPayload payload) {
        MarkSegments markSegments = () -> {
            Interval interval = payload.getInterval();
            if (interval != null) {
                return this.segmentsMetadata.markAsUnusedSegmentsInInterval(dataSourceName, interval);
            }
            Set<String> segmentIds = payload.getSegmentIds();
            return this.segmentsMetadata.markSegmentsAsUnused(dataSourceName, segmentIds);
        };
        return this.doMarkSegmentsWithPayload("markSegmentsAsUnused", dataSourceName, payload, markSegments);
    }

    private Response doMarkSegmentsWithPayload(String method, String dataSourceName, MarkDataSourceSegmentsPayload payload, MarkSegments markSegments) {
        if (payload == null || !payload.isValid()) {
            log.warn("Invalid request payload: [%s]", payload);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request payload, either interval or segmentIds array must be specified").build();
        }
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        return DataSourcesResource.doMarkSegments(method, dataSourceName, markSegments);
    }

    private static Response logAndCreateDataSourceNotFoundResponse(String dataSourceName) {
        log.warn("datasource not found [%s]", dataSourceName);
        return Response.noContent().build();
    }

    private static Response doMarkSegments(String method, String dataSourceName, MarkSegments markSegments) {
        try {
            int numChangedSegments = markSegments.markSegments();
            return Response.ok(ImmutableMap.of("numChangedSegments", numChangedSegments)).build();
        }
        catch (UnknownSegmentIdException e) {
            log.warn("Segment ids %s are not found", e.getUnknownSegmentIds());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ImmutableMap.of("message", e.getMessage())).build();
        }
        catch (Exception e) {
            log.error(e, "Error occurred during [%s] call, data source: [%s]", method, dataSourceName);
            return Response.serverError().entity(ImmutableMap.of("error", "Exception occurred.", "message", Throwables.getRootCause(e).toString())).build();
        }
    }

    @DELETE
    @Deprecated
    @Path(value="/{dataSourceName}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response markAsUnusedAllSegmentsOrKillSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="kill") String kill, @QueryParam(value="interval") String interval) {
        boolean killSegments;
        if (this.indexingServiceClient == null) {
            return Response.ok(ImmutableMap.of("error", "no indexing service found")).build();
        }
        boolean bl = killSegments = kill != null && Boolean.valueOf(kill) != false;
        if (killSegments) {
            return this.killSegmentsInInterval(dataSourceName, interval);
        }
        MarkSegments markSegments = () -> this.segmentsMetadata.markAsUnusedAllSegmentsInDataSource(dataSourceName);
        return DataSourcesResource.doMarkSegments("markAsUnusedAllSegments", dataSourceName, markSegments);
    }

    @DELETE
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response killSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.ok(ImmutableMap.of("error", "no indexing service found")).build();
        }
        if (StringUtils.contains((String)interval, (char)'_')) {
            log.warn("Use interval with '/', not '_': [%s] given", interval);
        }
        Interval theInterval = Intervals.of(interval.replace('_', '/'));
        try {
            this.indexingServiceClient.killSegments(dataSourceName, theInterval);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().entity(ImmutableMap.of("error", "Exception occurred. Are you sure you have an indexing service?", "message", e.toString())).build();
        }
    }

    @GET
    @Path(value="/{dataSourceName}/intervals")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getIntervalsWithServedSegmentsOrAllServedSegmentsPerIntervals(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        if (simple == null && full == null) {
            ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
            if (dataSource == null) {
                return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
            }
            Comparator<Interval> comparator = Comparators.intervalsByStartThenEnd().reversed();
            TreeSet<Interval> intervals = new TreeSet<Interval>(comparator);
            dataSource.getSegments().forEach(segment -> intervals.add(segment.getInterval()));
            return Response.ok(intervals).build();
        }
        return this.getServedSegmentsInInterval(dataSourceName, full != null, interval -> true);
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getServedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        Interval theInterval = Intervals.of(interval.replace('_', '/'));
        if (simple == null && full == null) {
            ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
            if (dataSource == null) {
                return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
            }
            TreeSet<SegmentId> segmentIds = new TreeSet<SegmentId>();
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                segmentIds.add(dataSegment.getId());
            }
            return Response.ok(segmentIds).build();
        }
        return this.getServedSegmentsInInterval(dataSourceName, full != null, arg_0 -> ((Interval)theInterval).contains(arg_0));
    }

    private Response getServedSegmentsInInterval(String dataSourceName, boolean full, Predicate<Interval> intervalFilter) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        Comparator<Interval> comparator = Comparators.intervalsByStartThenEnd().reversed();
        if (full) {
            TreeMap<Interval, Map> retVal = new TreeMap<Interval, Map>(comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!intervalFilter.test(dataSegment.getInterval())) continue;
                Map segments = retVal.computeIfAbsent(dataSegment.getInterval(), i -> new HashMap());
                Pair<DataSegment, Set<String>> segmentAndServers = this.getServersWhereSegmentIsServed(dataSegment.getId());
                if (segmentAndServers == null) continue;
                segments.put(dataSegment.getId(), ImmutableMap.of("metadata", segmentAndServers.lhs, "servers", segmentAndServers.rhs));
            }
            return Response.ok(retVal).build();
        }
        TreeMap<Interval, Map> statsPerInterval = new TreeMap<Interval, Map>(comparator);
        for (DataSegment dataSegment : dataSource.getSegments()) {
            if (!intervalFilter.test(dataSegment.getInterval())) continue;
            Map properties = statsPerInterval.computeIfAbsent(dataSegment.getInterval(), i -> new EnumMap(SimpleProperties.class));
            properties.merge(SimpleProperties.size, dataSegment.getSize(), (a, b) -> (Long)a + (Long)b);
            properties.merge(SimpleProperties.count, 1, (a, b) -> (Integer)a + (Integer)b);
        }
        return Response.ok(statsPerInterval).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getAllServedSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        Response.ResponseBuilder builder = Response.ok();
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity(Iterables.transform(dataSource.getSegments(), DataSegment::getId)).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getServedSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        for (SegmentId possibleSegmentId : SegmentId.iteratePossibleParsingsWithDataSource(dataSourceName, segmentId)) {
            Pair<DataSegment, Set<String>> retVal = this.getServersWhereSegmentIsServed(possibleSegmentId);
            if (retVal == null) continue;
            return Response.ok(ImmutableMap.of("metadata", retVal.lhs, "servers", retVal.rhs)).build();
        }
        log.warn("Segment id [%s] is unknown", segmentId);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markSegmentAsUnused(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        boolean segmentStateChanged = this.segmentsMetadata.markSegmentAsUnused(segmentId);
        return Response.ok(ImmutableMap.of("segmentStateChanged", segmentStateChanged)).build();
    }

    @POST
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markSegmentAsUsed(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        boolean segmentStateChanged = this.segmentsMetadata.markSegmentAsUsed(segmentId);
        return Response.ok().entity(ImmutableMap.of("segmentStateChanged", segmentStateChanged)).build();
    }

    @GET
    @Path(value="/{dataSourceName}/tiers")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getTiersWhereSegmentsAreServed(@PathParam(value="dataSourceName") String dataSourceName) {
        HashSet<String> retVal = new HashSet<String>();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            if (druidServer.getDataSource(dataSourceName) == null) continue;
            retVal.add(druidServer.getTier());
        }
        return Response.ok(retVal).build();
    }

    @Nullable
    private ImmutableDruidDataSource getDataSource(String dataSourceName) {
        List dataSources = this.serverInventoryView.getInventory().stream().map(server -> server.getDataSource(dataSourceName)).filter(Objects::nonNull).collect(Collectors.toList());
        if (dataSources.isEmpty()) {
            return null;
        }
        TreeMap<SegmentId, DataSegment> segmentMap = new TreeMap<SegmentId, DataSegment>();
        for (DruidDataSource dataSource : dataSources) {
            Collection<DataSegment> segments = dataSource.getSegments();
            for (DataSegment segment : segments) {
                segmentMap.put(segment.getId(), segment);
            }
        }
        return new ImmutableDruidDataSource(dataSourceName, Collections.emptyMap(), segmentMap);
    }

    @Nullable
    private Pair<DataSegment, Set<String>> getServersWhereSegmentIsServed(SegmentId segmentId) {
        DataSegment theSegment = null;
        HashSet<String> servers = new HashSet<String>();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DataSegment currSegment = druidServer.getSegment(segmentId);
            if (currSegment == null) continue;
            theSegment = currSegment;
            servers.add(druidServer.getHost());
        }
        if (theSegment == null) {
            return null;
        }
        return new Pair(theSegment, servers);
    }

    private Map<String, Object> makeSimpleDatasource(ImmutableDruidDataSource input) {
        return new ImmutableMap.Builder<String, String>().put("name", input.getName()).put("properties", (String)((Object)this.getSimpleDatasource(input.getName()))).build();
    }

    private Map<String, Map<String, Object>> getSimpleDatasource(String dataSourceName) {
        HashMap<String, HashMap<String, Object>> tiers = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Number> segments = new HashMap<String, Number>();
        ImmutableMap<String, Map<String, Object>> retVal = ImmutableMap.of("tiers", tiers, "segments", segments);
        HashSet<SegmentId> totalDistinctSegments = new HashSet<SegmentId>();
        HashMap<String, HashSet> tierDistinctSegments = new HashMap<String, HashSet>();
        long totalSegmentSize = 0L;
        long totalReplicatedSize = 0L;
        DateTime minTime = DateTimes.MAX;
        DateTime maxTime = DateTimes.MIN;
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DruidDataSource druidDataSource = druidServer.getDataSource(dataSourceName);
            String tier = druidServer.getTier();
            if (druidDataSource == null) continue;
            tierDistinctSegments.computeIfAbsent(tier, t -> new HashSet());
            long dataSourceSegmentSize = 0L;
            long replicatedSegmentSize = 0L;
            for (DataSegment dataSegment : druidDataSource.getSegments()) {
                if (!((HashSet)tierDistinctSegments.get(tier)).contains(dataSegment.getId())) {
                    dataSourceSegmentSize += dataSegment.getSize();
                    ((HashSet)tierDistinctSegments.get(tier)).add(dataSegment.getId());
                }
                if (totalDistinctSegments.add(dataSegment.getId())) {
                    totalSegmentSize += dataSegment.getSize();
                    minTime = DateTimes.min(minTime, dataSegment.getInterval().getStart());
                    maxTime = DateTimes.max(maxTime, dataSegment.getInterval().getEnd());
                }
                totalReplicatedSize += dataSegment.getSize();
                replicatedSegmentSize += dataSegment.getSize();
            }
            HashMap<String, Object> tierStats = (HashMap<String, Object>)tiers.get(tier);
            if (tierStats == null) {
                tierStats = new HashMap<String, Object>();
                tiers.put(druidServer.getTier(), tierStats);
            }
            tierStats.put("segmentCount", ((HashSet)tierDistinctSegments.get(tier)).size());
            long segmentSize = MapUtils.getLong(tierStats, "size", 0L);
            tierStats.put("size", segmentSize + dataSourceSegmentSize);
            long replicatedSize = MapUtils.getLong(tierStats, "replicatedSize", 0L);
            tierStats.put("replicatedSize", replicatedSize + replicatedSegmentSize);
        }
        segments.put("count", totalDistinctSegments.size());
        segments.put("size", totalSegmentSize);
        segments.put("replicatedSize", totalReplicatedSize);
        segments.put("minTime", (Number)minTime);
        segments.put("maxTime", (Number)maxTime);
        return retVal;
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}/serverview")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getServedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="partial") boolean partial) {
        VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline(new TableDataSource(dataSourceName));
        Interval theInterval = Intervals.of(interval.replace('_', '/'));
        if (timeline == null) {
            log.debug("No timeline found for datasource[%s]", dataSourceName);
            return Response.ok(new ArrayList()).build();
        }
        return Response.ok(this.prepareServedSegmentsInInterval(timeline, theInterval)).build();
    }

    private Iterable<ImmutableSegmentLoadInfo> prepareServedSegmentsInInterval(TimelineLookup<String, SegmentLoadInfo> dataSourceServingTimeline, Interval interval) {
        List<TimelineObjectHolder<String, SegmentLoadInfo>> lookup = dataSourceServingTimeline.lookupWithIncompletePartitions(interval);
        return FunctionalIterable.create(lookup).transformCat(input -> Iterables.transform(input.getObject(), chunk -> ((SegmentLoadInfo)chunk.getObject()).toImmutableSegmentLoadInfo()));
    }

    @GET
    @Path(value="/{dataSourceName}/handoffComplete")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response isHandOffComplete(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval, @QueryParam(value="partitionNumber") int partitionNumber, @QueryParam(value="version") String version) {
        try {
            List<Rule> rules = this.metadataRuleManager.getRulesWithDefault(dataSourceName);
            Interval theInterval = Intervals.of(interval);
            SegmentDescriptor descriptor = new SegmentDescriptor(theInterval, version, partitionNumber);
            DateTime now = DateTimes.nowUtc();
            boolean dropped = true;
            for (Rule rule : rules) {
                if (!rule.appliesTo(theInterval, now)) continue;
                if (!(rule instanceof LoadRule)) break;
                dropped = false;
                break;
            }
            if (dropped) {
                return Response.ok((Object)true).build();
            }
            VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline(new TableDataSource(dataSourceName));
            if (timeline == null) {
                log.debug("No timeline found for datasource[%s]", dataSourceName);
                return Response.ok((Object)false).build();
            }
            Iterable<ImmutableSegmentLoadInfo> servedSegmentsInInterval = this.prepareServedSegmentsInInterval(timeline, theInterval);
            if (DataSourcesResource.isSegmentLoaded(servedSegmentsInInterval, descriptor)) {
                return Response.ok((Object)true).build();
            }
            return Response.ok((Object)false).build();
        }
        catch (Exception e) {
            log.error(e, "Error while handling hand off check request", new Object[0]);
            return Response.serverError().entity(ImmutableMap.of("error", e.toString())).build();
        }
    }

    static boolean isSegmentLoaded(Iterable<ImmutableSegmentLoadInfo> servedSegments, SegmentDescriptor descriptor) {
        for (ImmutableSegmentLoadInfo segmentLoadInfo : servedSegments) {
            if (!segmentLoadInfo.getSegment().getInterval().contains((ReadableInterval)descriptor.getInterval()) || segmentLoadInfo.getSegment().getShardSpec().getPartitionNum() != descriptor.getPartitionNumber() || segmentLoadInfo.getSegment().getVersion().compareTo(descriptor.getVersion()) < 0 || !Iterables.any(segmentLoadInfo.getServers(), DruidServerMetadata::segmentReplicatable)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected static class MarkDataSourceSegmentsPayload {
        private final Interval interval;
        private final Set<String> segmentIds;

        @JsonCreator
        public MarkDataSourceSegmentsPayload(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="segmentIds") Set<String> segmentIds) {
            this.interval = interval;
            this.segmentIds = segmentIds;
        }

        @JsonProperty
        public Interval getInterval() {
            return this.interval;
        }

        @JsonProperty
        public Set<String> getSegmentIds() {
            return this.segmentIds;
        }

        public boolean isValid() {
            return this.interval == null ^ this.segmentIds == null && (this.segmentIds == null || !this.segmentIds.isEmpty());
        }
    }

    static enum SimpleProperties {
        size,
        count;

    }

    private static interface MarkSegments {
        public int markSegments() throws UnknownSegmentIdException;
    }
}

