/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.rules;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.DropRule;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class PeriodDropBeforeRule
extends DropRule {
    private final Period period;

    @JsonCreator
    public PeriodDropBeforeRule(@JsonProperty(value="period") Period period) {
        this.period = period;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "dropBeforeByPeriod";
    }

    @JsonProperty
    public Period getPeriod() {
        return this.period;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval theInterval, DateTime referenceTimestamp) {
        DateTime periodAgo = referenceTimestamp.minus((ReadablePeriod)this.period);
        return theInterval.getEndMillis() <= periodAgo.getMillis();
    }
}

