/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.rules;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rules;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class IntervalLoadRule
extends LoadRule {
    private static final Logger log = new Logger(IntervalLoadRule.class);
    private final Interval interval;
    private final Map<String, Integer> tieredReplicants;

    @JsonCreator
    public IntervalLoadRule(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="tieredReplicants") Map<String, Integer> tieredReplicants) {
        this.tieredReplicants = tieredReplicants == null ? ImmutableMap.of("_default_tier", 2) : tieredReplicants;
        IntervalLoadRule.validateTieredReplicants(this.tieredReplicants);
        this.interval = interval;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "loadByInterval";
    }

    @Override
    @JsonProperty
    public Map<String, Integer> getTieredReplicants() {
        return this.tieredReplicants;
    }

    @Override
    public int getNumReplicants(String tier) {
        Integer retVal = this.tieredReplicants.get(tier);
        return retVal == null ? 0 : retVal;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval theInterval, DateTime referenceTimestamp) {
        return Rules.eligibleForLoad(this.interval, theInterval);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalLoadRule that = (IntervalLoadRule)o;
        if (this.interval != null ? !this.interval.equals((Object)that.interval) : that.interval != null) {
            return false;
        }
        return !(this.tieredReplicants != null ? !this.tieredReplicants.equals(that.tieredReplicants) : that.tieredReplicants != null);
    }

    public int hashCode() {
        int result = this.interval != null ? this.interval.hashCode() : 0;
        result = 31 * result + (this.tieredReplicants != null ? this.tieredReplicants.hashCode() : 0);
        return result;
    }
}

