/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.cost;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.server.coordinator.cost.ServerCostCache;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.utils.CollectionUtils;

public class ClusterCostCache {
    private final Map<String, ServerCostCache> serversCostCache;

    ClusterCostCache(Map<String, ServerCostCache> serversCostCache) {
        this.serversCostCache = Preconditions.checkNotNull(serversCostCache);
    }

    public double computeCost(String serverName, DataSegment dataSegment) {
        ServerCostCache serverCostCache = this.serversCostCache.get(serverName);
        return serverCostCache != null ? serverCostCache.computeCost(dataSegment) : 0.0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map<String, Set<DataSegment>> segmentsByServerName) {
        Builder builder = ClusterCostCache.builder();
        segmentsByServerName.forEach((serverName, segments) -> segments.forEach(segment -> builder.addSegment((String)serverName, (DataSegment)segment)));
        return builder;
    }

    public static class Builder {
        private final Map<String, ServerCostCache.Builder> serversCostCache = new HashMap<String, ServerCostCache.Builder>();

        public void addSegment(String serverName, DataSegment dataSegment) {
            ServerCostCache.Builder builder = this.serversCostCache.computeIfAbsent(serverName, s -> ServerCostCache.builder());
            builder.addSegment(dataSegment);
        }

        public void removeSegment(String serverName, DataSegment dataSegment) {
            this.serversCostCache.computeIfPresent(serverName, (s, builder) -> builder.removeSegment(dataSegment).isEmpty() ? null : builder);
        }

        public void removeServer(String serverName) {
            this.serversCostCache.remove(serverName);
        }

        public ClusterCostCache build() {
            return new ClusterCostCache(CollectionUtils.mapValues(this.serversCostCache, ServerCostCache.Builder::build));
        }
    }
}

