/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.hive.druid.com.google.common.collect.HashBasedTable;
import org.apache.hive.druid.com.google.common.collect.Table;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.org.apache.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;

public class SegmentReplicantLookup {
    private final Table<SegmentId, String, Integer> segmentsInCluster;
    private final Table<SegmentId, String, Integer> loadingSegments;

    public static SegmentReplicantLookup make(DruidCluster cluster) {
        HashBasedTable<SegmentId, String, Integer> segmentsInCluster = HashBasedTable.create();
        HashBasedTable<SegmentId, String, Integer> loadingSegments = HashBasedTable.create();
        for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : sortedSet) {
                Integer numReplicants;
                ImmutableDruidServer server = serverHolder.getServer();
                for (DataSegment segment : server.iterateAllSegments()) {
                    numReplicants = (Integer)segmentsInCluster.get(segment.getId(), server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    segmentsInCluster.put(segment.getId(), server.getTier(), numReplicants + 1);
                }
                for (DataSegment segment : serverHolder.getPeon().getSegmentsToLoad()) {
                    numReplicants = (Integer)loadingSegments.get(segment.getId(), server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    loadingSegments.put(segment.getId(), server.getTier(), numReplicants + 1);
                }
            }
        }
        return new SegmentReplicantLookup(segmentsInCluster, loadingSegments);
    }

    private SegmentReplicantLookup(Table<SegmentId, String, Integer> segmentsInCluster, Table<SegmentId, String, Integer> loadingSegments) {
        this.segmentsInCluster = segmentsInCluster;
        this.loadingSegments = loadingSegments;
    }

    public Map<String, Integer> getClusterTiers(SegmentId segmentId) {
        HashMap retVal = this.segmentsInCluster.row(segmentId);
        return retVal == null ? new HashMap() : retVal;
    }

    int getLoadedReplicants(SegmentId segmentId) {
        Map<String, Integer> allTiers = this.segmentsInCluster.row(segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    int getLoadedReplicants(SegmentId segmentId, String tier) {
        Integer retVal = this.segmentsInCluster.get(segmentId, tier);
        return retVal == null ? 0 : retVal;
    }

    private int getLoadingReplicants(SegmentId segmentId, String tier) {
        Integer retVal = this.loadingSegments.get(segmentId, tier);
        return retVal == null ? 0 : retVal;
    }

    private int getLoadingReplicants(SegmentId segmentId) {
        Map<String, Integer> allTiers = this.loadingSegments.row(segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    public int getTotalReplicants(SegmentId segmentId) {
        return this.getLoadedReplicants(segmentId) + this.getLoadingReplicants(segmentId);
    }

    public int getTotalReplicants(SegmentId segmentId, String tier) {
        return this.getLoadedReplicants(segmentId, tier) + this.getLoadingReplicants(segmentId, tier);
    }
}

