/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hive.druid.org.apache.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.hive.druid.org.apache.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

final class ReservoirSegmentSampler {
    static BalancerSegmentHolder getRandomBalancerSegmentHolder(List<ServerHolder> serverHolders) {
        ServerHolder fromServerHolder = null;
        DataSegment proposalSegment = null;
        int numSoFar = 0;
        for (ServerHolder server : serverHolders) {
            for (DataSegment segment : server.getServer().iterateAllSegments()) {
                int randNum = ThreadLocalRandom.current().nextInt(numSoFar + 1);
                if (randNum == numSoFar) {
                    fromServerHolder = server;
                    proposalSegment = segment;
                }
                ++numSoFar;
            }
        }
        if (fromServerHolder != null) {
            return new BalancerSegmentHolder(fromServerHolder.getServer(), proposalSegment);
        }
        return null;
    }

    private ReservoirSegmentSampler() {
    }
}

