/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.org.apache.druid.indexer.TaskStatusPlus;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class DruidCoordinatorCleanupPendingSegments
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorCleanupPendingSegments.class);
    private static final Period KEEP_PENDING_SEGMENTS_OFFSET = new Period((Object)"P1D");
    private final IndexingServiceClient indexingServiceClient;

    @Inject
    public DruidCoordinatorCleanupPendingSegments(IndexingServiceClient indexingServiceClient) {
        this.indexingServiceClient = indexingServiceClient;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        ArrayList<Object> createdTimes = new ArrayList<Object>();
        createdTimes.add(this.indexingServiceClient.getActiveTasks().stream().map(TaskStatusPlus::getCreatedTime).min(Comparators.naturalNullsFirst()).orElse(DateTimes.nowUtc()));
        TaskStatusPlus completeTaskStatus = this.indexingServiceClient.getLastCompleteTask();
        if (completeTaskStatus != null) {
            createdTimes.add(completeTaskStatus.getCreatedTime());
        }
        createdTimes.sort(Comparators.naturalNullsFirst());
        Preconditions.checkState(!createdTimes.isEmpty(), "Failed to gather createdTimes of tasks");
        DateTime stalePendingSegmentsCutoffCreationTime = ((DateTime)createdTimes.get(0)).minus((ReadablePeriod)KEEP_PENDING_SEGMENTS_OFFSET);
        for (String dataSource : params.getUsedSegmentsTimelinesPerDataSource().keySet()) {
            if (params.getCoordinatorDynamicConfig().getDataSourcesToNotKillStalePendingSegmentsIn().contains(dataSource)) continue;
            log.info("Killed [%d] pendingSegments created until [%s] for dataSource[%s]", this.indexingServiceClient.killPendingSegments(dataSource, stalePendingSegmentsCutoffCreationTime), stalePendingSegmentsCutoffCreationTime, dataSource);
        }
        return params;
    }
}

