/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordination;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.cache.Cache;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.AbstractFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.server.SegmentManager;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

@ManageLifecycle
public class SegmentLoadDropHandler
implements DataSegmentChangeHandler {
    private static final EmittingLogger log = new EmittingLogger(SegmentLoadDropHandler.class);
    private final Object segmentDeleteLock = new Object();
    private final Object startStopLock = new Object();
    private final ObjectMapper jsonMapper;
    private final SegmentLoaderConfig config;
    private final DataSegmentAnnouncer announcer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentManager segmentManager;
    private final ScheduledExecutorService exec;
    private final ConcurrentSkipListSet<DataSegment> segmentsToDelete;
    private volatile boolean started = false;
    private final Cache<DataSegmentChangeRequest, AtomicReference<Status>> requestStatuses;
    private final Object requestStatusesLock = new Object();
    private final LinkedHashSet<CustomSettableFuture> waitingFutures = new LinkedHashSet();

    @Inject
    public SegmentLoadDropHandler(ObjectMapper jsonMapper, SegmentLoaderConfig config, DataSegmentAnnouncer announcer, DataSegmentServerAnnouncer serverAnnouncer, SegmentManager segmentManager) {
        this(jsonMapper, config, announcer, serverAnnouncer, segmentManager, Executors.newScheduledThreadPool(config.getNumLoadingThreads(), Execs.makeThreadFactory("SimpleDataSegmentChangeHandler-%s")));
    }

    @VisibleForTesting
    SegmentLoadDropHandler(ObjectMapper jsonMapper, SegmentLoaderConfig config, DataSegmentAnnouncer announcer, DataSegmentServerAnnouncer serverAnnouncer, SegmentManager segmentManager, ScheduledExecutorService exec) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.announcer = announcer;
        this.serverAnnouncer = serverAnnouncer;
        this.segmentManager = segmentManager;
        this.exec = exec;
        this.segmentsToDelete = new ConcurrentSkipListSet();
        this.requestStatuses = CacheBuilder.newBuilder().maximumSize(config.getStatusQueueMaxSize()).initialCapacity(8).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws IOException {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            log.info("Starting...", new Object[0]);
            try {
                this.loadLocalCache();
                this.serverAnnouncer.announce();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible(e, IOException.class);
                throw new RuntimeException(e);
            }
            this.started = true;
            log.info("Started.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("Stopping...", new Object[0]);
            try {
                this.serverAnnouncer.unannounce();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.started = false;
            }
            log.info("Stopped.", new Object[0]);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private void loadLocalCache() {
        long start = System.currentTimeMillis();
        File baseDir = this.config.getInfoDir();
        if (!baseDir.isDirectory()) {
            if (baseDir.exists()) {
                throw new ISE("[%s] exists but not a directory.", baseDir);
            }
            if (!baseDir.mkdirs()) {
                throw new ISE("Failed to create directory[%s].", baseDir);
            }
        }
        ArrayList<DataSegment> cachedSegments = new ArrayList<DataSegment>();
        File[] segmentsToLoad = baseDir.listFiles();
        int ignored = 0;
        for (int i = 0; i < segmentsToLoad.length; ++i) {
            File file = segmentsToLoad[i];
            log.info("Loading segment cache file [%d/%d][%s].", i + 1, segmentsToLoad.length, file);
            try {
                DataSegment segment = this.jsonMapper.readValue(file, DataSegment.class);
                if (!segment.getId().toString().equals(file.getName())) {
                    log.warn("Ignoring cache file[%s] for segment[%s].", file.getPath(), segment.getId());
                    ++ignored;
                    continue;
                }
                if (this.segmentManager.isSegmentCached(segment)) {
                    cachedSegments.add(segment);
                    continue;
                }
                log.warn("Unable to find cache file for %s. Deleting lookup entry", segment.getId());
                File segmentInfoCacheFile = new File(baseDir, segment.getId().toString());
                if (segmentInfoCacheFile.delete()) continue;
                log.warn("Unable to delete segmentInfoCacheFile[%s]", segmentInfoCacheFile);
                continue;
            }
            catch (Exception e) {
                log.makeAlert(e, "Failed to load segment from segmentInfo file", new Object[0]).addData("file", file).emit();
            }
        }
        if (ignored > 0) {
            log.makeAlert("Ignored misnamed segment cache files on startup.", new Object[0]).addData("numIgnored", ignored).emit();
        }
        this.addSegments(cachedSegments, () -> log.info("Cache load took %,d ms", System.currentTimeMillis() - start));
    }

    private void loadSegment(DataSegment segment, DataSegmentChangeCallback callback, boolean lazy) throws SegmentLoadingException {
        File segmentInfoCacheFile;
        boolean loaded;
        try {
            loaded = this.segmentManager.loadSegment(segment, lazy);
        }
        catch (Exception e) {
            this.removeSegment(segment, callback, false);
            throw new SegmentLoadingException(e, "Exception loading segment[%s]", segment.getId());
        }
        if (loaded && !(segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getId().toString())).exists()) {
            try {
                this.jsonMapper.writeValue(segmentInfoCacheFile, (Object)segment);
            }
            catch (IOException e) {
                this.removeSegment(segment, callback, false);
                throw new SegmentLoadingException(e, "Failed to write to disk segment info cache file[%s]", segmentInfoCacheFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSegment(DataSegment segment, DataSegmentChangeCallback callback) {
        Status result = null;
        try {
            log.info("Loading segment %s", segment.getId());
            if (this.segmentsToDelete.contains(segment)) {
                Object object = this.segmentDeleteLock;
                synchronized (object) {
                    this.segmentsToDelete.remove(segment);
                }
            }
            this.loadSegment(segment, DataSegmentChangeCallback.NOOP, false);
            try {
                this.announcer.announceSegment(segment);
            }
            catch (IOException e) {
                throw new SegmentLoadingException(e, "Failed to announce segment[%s]", segment.getId());
            }
            result = Status.SUCCESS;
            this.updateRequestStatus(new SegmentChangeRequestLoad(segment), result);
            callback.execute();
        }
        catch (Exception e) {
            try {
                log.makeAlert(e, "Failed to load segment for dataSource", new Object[0]).addData("segment", segment).emit();
                result = Status.failed(e.getMessage());
                this.updateRequestStatus(new SegmentChangeRequestLoad(segment), result);
                callback.execute();
            }
            catch (Throwable throwable) {
                this.updateRequestStatus(new SegmentChangeRequestLoad(segment), result);
                callback.execute();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSegments(Collection<DataSegment> segments, DataSegmentChangeCallback callback) {
        ExecutorService loadingExecutor = null;
        try (BackgroundSegmentAnnouncer backgroundSegmentAnnouncer = new BackgroundSegmentAnnouncer(this.announcer, this.exec, this.config.getAnnounceIntervalMillis());){
            backgroundSegmentAnnouncer.startAnnouncing();
            loadingExecutor = Execs.multiThreaded(this.config.getNumBootstrapThreads(), "Segment-Load-Startup-%s");
            int numSegments = segments.size();
            CountDownLatch latch = new CountDownLatch(numSegments);
            AtomicInteger counter = new AtomicInteger(0);
            CopyOnWriteArrayList failedSegments = new CopyOnWriteArrayList();
            for (DataSegment segment : segments) {
                loadingExecutor.submit(() -> {
                    try {
                        log.info("Loading segment[%d/%d][%s]", counter.incrementAndGet(), numSegments, segment.getId());
                        this.loadSegment(segment, callback, this.config.isLazyLoadOnStart());
                        try {
                            backgroundSegmentAnnouncer.announceSegment(segment);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new SegmentLoadingException(e, "Loading Interrupted", new Object[0]);
                        }
                    }
                    catch (SegmentLoadingException e) {
                        log.error(e, "[%s] failed to load", segment.getId());
                        failedSegments.add(segment);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
                if (failedSegments.size() > 0) {
                    log.makeAlert("%,d errors seen while loading segments", failedSegments.size()).addData("failedSegments", failedSegments).emit();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.makeAlert(e, "LoadingInterrupted", new Object[0]).emit();
            }
            backgroundSegmentAnnouncer.finishAnnouncing();
        }
        catch (SegmentLoadingException e) {
            log.makeAlert(e, "Failed to load segments -- likely problem with announcing.", new Object[0]).addData("numSegments", segments.size()).emit();
        }
        finally {
            callback.execute();
            if (loadingExecutor != null) {
                loadingExecutor.shutdownNow();
            }
        }
    }

    @Override
    public void removeSegment(DataSegment segment, DataSegmentChangeCallback callback) {
        this.removeSegment(segment, callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSegment(DataSegment segment, DataSegmentChangeCallback callback, boolean scheduleDrop) {
        Status result = null;
        try {
            this.announcer.unannounceSegment(segment);
            this.segmentsToDelete.add(segment);
            Runnable runnable = () -> {
                try {
                    Object object = this.segmentDeleteLock;
                    synchronized (object) {
                        if (this.segmentsToDelete.remove(segment)) {
                            this.segmentManager.dropSegment(segment);
                            File segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getId().toString());
                            if (!segmentInfoCacheFile.delete()) {
                                log.warn("Unable to delete segmentInfoCacheFile[%s]", segmentInfoCacheFile);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.makeAlert(e, "Failed to remove segment! Possible resource leak!", new Object[0]).addData("segment", segment).emit();
                }
            };
            if (scheduleDrop) {
                log.info("Completely removing [%s] in [%,d] millis", segment.getId(), this.config.getDropSegmentDelayMillis());
                this.exec.schedule(runnable, (long)this.config.getDropSegmentDelayMillis(), TimeUnit.MILLISECONDS);
            } else {
                runnable.run();
            }
            result = Status.SUCCESS;
            this.updateRequestStatus(new SegmentChangeRequestDrop(segment), result);
            callback.execute();
        }
        catch (Exception e) {
            try {
                log.makeAlert(e, "Failed to remove segment", new Object[0]).addData("segment", segment).emit();
                result = Status.failed(e.getMessage());
                this.updateRequestStatus(new SegmentChangeRequestDrop(segment), result);
                callback.execute();
            }
            catch (Throwable throwable) {
                this.updateRequestStatus(new SegmentChangeRequestDrop(segment), result);
                callback.execute();
                throw throwable;
            }
        }
    }

    public Collection<DataSegment> getPendingDeleteSnapshot() {
        return ImmutableList.copyOf(this.segmentsToDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<List<DataSegmentChangeRequestAndStatus>> processBatch(List<DataSegmentChangeRequest> changeRequests) {
        boolean isAnyRequestDone = false;
        HashMap<DataSegmentChangeRequest, AtomicReference<Status>> statuses = Maps.newHashMapWithExpectedSize(changeRequests.size());
        for (DataSegmentChangeRequest cr : changeRequests) {
            AtomicReference<Status> status = this.processRequest(cr);
            if (status.get().getState() != Status.STATE.PENDING) {
                isAnyRequestDone = true;
            }
            statuses.put(cr, status);
        }
        CustomSettableFuture future = new CustomSettableFuture(this.waitingFutures, statuses);
        if (isAnyRequestDone) {
            future.resolve();
        } else {
            LinkedHashSet<CustomSettableFuture> linkedHashSet = this.waitingFutures;
            synchronized (linkedHashSet) {
                this.waitingFutures.add(future);
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicReference<Status> processRequest(final DataSegmentChangeRequest changeRequest) {
        Object object = this.requestStatusesLock;
        synchronized (object) {
            if (this.requestStatuses.getIfPresent(changeRequest) == null) {
                changeRequest.go(new DataSegmentChangeHandler(){

                    @Override
                    public void addSegment(DataSegment segment, DataSegmentChangeCallback callback) {
                        SegmentLoadDropHandler.this.requestStatuses.put(changeRequest, new AtomicReference<Status>(Status.PENDING));
                        SegmentLoadDropHandler.this.exec.submit(() -> SegmentLoadDropHandler.this.addSegment(((SegmentChangeRequestLoad)changeRequest).getSegment(), () -> SegmentLoadDropHandler.this.resolveWaitingFutures()));
                    }

                    @Override
                    public void removeSegment(DataSegment segment, DataSegmentChangeCallback callback) {
                        SegmentLoadDropHandler.this.requestStatuses.put(changeRequest, new AtomicReference<Status>(Status.PENDING));
                        SegmentLoadDropHandler.this.removeSegment(((SegmentChangeRequestDrop)changeRequest).getSegment(), () -> SegmentLoadDropHandler.this.resolveWaitingFutures(), true);
                    }
                }, this::resolveWaitingFutures);
            }
            return this.requestStatuses.getIfPresent(changeRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRequestStatus(DataSegmentChangeRequest changeRequest, Status result) {
        if (result == null) {
            result = Status.failed("Unknown reason. Check server logs.");
        }
        Object object = this.requestStatusesLock;
        synchronized (object) {
            AtomicReference<Status> statusRef = this.requestStatuses.getIfPresent(changeRequest);
            if (statusRef != null) {
                statusRef.set(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveWaitingFutures() {
        LinkedHashSet<CustomSettableFuture> waitingFuturesCopy = new LinkedHashSet<CustomSettableFuture>();
        LinkedHashSet<CustomSettableFuture> linkedHashSet = this.waitingFutures;
        synchronized (linkedHashSet) {
            waitingFuturesCopy.addAll(this.waitingFutures);
            this.waitingFutures.clear();
        }
        for (CustomSettableFuture future : waitingFuturesCopy) {
            future.resolve();
        }
    }

    public static class DataSegmentChangeRequestAndStatus {
        private final DataSegmentChangeRequest request;
        private final Status status;

        @JsonCreator
        public DataSegmentChangeRequestAndStatus(@JsonProperty(value="request") DataSegmentChangeRequest request, @JsonProperty(value="status") Status status) {
            this.request = request;
            this.status = status;
        }

        @JsonProperty
        public DataSegmentChangeRequest getRequest() {
            return this.request;
        }

        @JsonProperty
        public Status getStatus() {
            return this.status;
        }

        public String toString() {
            return "DataSegmentChangeRequestAndStatus{request=" + this.request + ", status=" + this.status + '}';
        }
    }

    public static class Status {
        private final STATE state;
        @Nullable
        private final String failureCause;
        public static final Status SUCCESS = new Status(STATE.SUCCESS, null);
        public static final Status PENDING = new Status(STATE.PENDING, null);

        @JsonCreator
        Status(@JsonProperty(value="state") STATE state, @JsonProperty(value="failureCause") @Nullable String failureCause) {
            Preconditions.checkNotNull(state, "state must be non-null");
            this.state = state;
            this.failureCause = failureCause;
        }

        public static Status failed(String cause) {
            return new Status(STATE.FAILED, cause);
        }

        @JsonProperty
        public STATE getState() {
            return this.state;
        }

        @Nullable
        @JsonProperty
        public String getFailureCause() {
            return this.failureCause;
        }

        public String toString() {
            return "Status{state=" + (Object)((Object)this.state) + ", failureCause='" + this.failureCause + '\'' + '}';
        }

        public static enum STATE {
            SUCCESS,
            FAILED,
            PENDING;

        }
    }

    private static class CustomSettableFuture
    extends AbstractFuture<List<DataSegmentChangeRequestAndStatus>> {
        private final LinkedHashSet<CustomSettableFuture> waitingFutures;
        private final Map<DataSegmentChangeRequest, AtomicReference<Status>> statusRefs;

        private CustomSettableFuture(LinkedHashSet<CustomSettableFuture> waitingFutures, Map<DataSegmentChangeRequest, AtomicReference<Status>> statusRefs) {
            this.waitingFutures = waitingFutures;
            this.statusRefs = statusRefs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolve() {
            Map<DataSegmentChangeRequest, AtomicReference<Status>> map = this.statusRefs;
            synchronized (map) {
                if (this.isDone()) {
                    return;
                }
                ArrayList result = new ArrayList(this.statusRefs.size());
                this.statusRefs.forEach((request, statusRef) -> result.add(new DataSegmentChangeRequestAndStatus((DataSegmentChangeRequest)request, (Status)statusRef.get())));
                this.set(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean interruptIfRunning) {
            LinkedHashSet<CustomSettableFuture> linkedHashSet = this.waitingFutures;
            synchronized (linkedHashSet) {
                this.waitingFutures.remove(this);
            }
            return true;
        }
    }

    private static class BackgroundSegmentAnnouncer
    implements AutoCloseable {
        private static final EmittingLogger log = new EmittingLogger(BackgroundSegmentAnnouncer.class);
        private final int intervalMillis;
        private final DataSegmentAnnouncer announcer;
        private final ScheduledExecutorService exec;
        private final LinkedBlockingQueue<DataSegment> queue;
        private final SettableFuture<Boolean> doneAnnouncing;
        private final Object lock = new Object();
        private volatile boolean finished = false;
        @Nullable
        private volatile ScheduledFuture startedAnnouncing = null;
        @Nullable
        private volatile ScheduledFuture nextAnnoucement = null;

        public BackgroundSegmentAnnouncer(DataSegmentAnnouncer announcer, ScheduledExecutorService exec, int intervalMillis) {
            this.announcer = announcer;
            this.exec = exec;
            this.intervalMillis = intervalMillis;
            this.queue = new LinkedBlockingQueue();
            this.doneAnnouncing = SettableFuture.create();
        }

        public void announceSegment(DataSegment segment) throws InterruptedException {
            if (this.finished) {
                throw new ISE("Announce segment called after finishAnnouncing", new Object[0]);
            }
            this.queue.put(segment);
        }

        public void startAnnouncing() {
            if (this.intervalMillis <= 0) {
                return;
            }
            log.info("Starting background segment announcing task", new Object[0]);
            this.nextAnnoucement = this.startedAnnouncing = this.exec.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = lock;
                    synchronized (object) {
                        try {
                            if (!finished || !queue.isEmpty()) {
                                ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
                                queue.drainTo(segments);
                                try {
                                    announcer.announceSegments(segments);
                                    nextAnnoucement = exec.schedule(this, (long)intervalMillis, TimeUnit.MILLISECONDS);
                                }
                                catch (IOException e) {
                                    doneAnnouncing.setException(new SegmentLoadingException(e, "Failed to announce segments[%s]", segments));
                                }
                            } else {
                                doneAnnouncing.set(true);
                            }
                        }
                        catch (Exception e) {
                            doneAnnouncing.setException(e);
                        }
                    }
                }
            }, (long)this.intervalMillis, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishAnnouncing() throws SegmentLoadingException {
            Object object = this.lock;
            synchronized (object) {
                this.finished = true;
                try {
                    ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
                    this.queue.drainTo(segments);
                    this.announcer.announceSegments(segments);
                }
                catch (Exception e) {
                    throw new SegmentLoadingException(e, "Failed to announce segments[%s]", this.queue);
                }
                try {
                    if (this.startedAnnouncing != null) {
                        this.startedAnnouncing.cancel(false);
                    }
                    if (this.doneAnnouncing.isDone()) {
                        this.doneAnnouncing.get();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SegmentLoadingException(e, "Loading Interrupted", new Object[0]);
                }
                catch (ExecutionException e) {
                    throw new SegmentLoadingException(e.getCause(), "Background Announcing Task Failed", new Object[0]);
                }
            }
            log.info("Completed background segment announcing", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.finished = true;
                if (this.nextAnnoucement != null) {
                    this.nextAnnoucement.cancel(false);
                }
            }
        }
    }
}

