/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordination;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.server.coordination.ServerType;

public class DruidServerMetadata {
    private final String name;
    private final String hostAndPort;
    @Nullable
    private final String hostAndTlsPort;
    private final long maxSize;
    private final String tier;
    private final ServerType type;
    private final int priority;

    @JsonCreator
    public DruidServerMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="host") String hostAndPort, @JsonProperty(value="hostAndTlsPort") @Nullable String hostAndTlsPort, @JsonProperty(value="maxSize") long maxSize, @JsonProperty(value="type") ServerType type, @JsonProperty(value="tier") String tier, @JsonProperty(value="priority") int priority) {
        this.name = Preconditions.checkNotNull(name);
        this.hostAndPort = hostAndPort;
        this.hostAndTlsPort = hostAndTlsPort;
        this.maxSize = maxSize;
        this.tier = tier;
        this.type = type;
        this.priority = priority;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.getHostAndTlsPort() != null ? this.getHostAndTlsPort() : this.getHostAndPort();
    }

    @JsonProperty(value="host")
    public String getHostAndPort() {
        return this.hostAndPort;
    }

    @Nullable
    @JsonProperty
    public String getHostAndTlsPort() {
        return this.hostAndTlsPort;
    }

    @JsonProperty
    public long getMaxSize() {
        return this.maxSize;
    }

    @JsonProperty
    public String getTier() {
        return this.tier;
    }

    @JsonProperty
    public ServerType getType() {
        return this.type;
    }

    @JsonProperty
    public int getPriority() {
        return this.priority;
    }

    public boolean segmentReplicatable() {
        return this.type.isSegmentReplicationTarget();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidServerMetadata that = (DruidServerMetadata)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Objects.equals(this.hostAndPort, that.hostAndPort)) {
            return false;
        }
        if (!Objects.equals(this.hostAndTlsPort, that.hostAndTlsPort)) {
            return false;
        }
        if (this.maxSize != that.maxSize) {
            return false;
        }
        if (!Objects.equals(this.tier, that.tier)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.priority == that.priority;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.hostAndPort, this.hostAndTlsPort, this.maxSize, this.tier, this.type, this.priority});
    }

    public String toString() {
        return "DruidServerMetadata{name='" + this.name + '\'' + ", hostAndPort='" + this.hostAndPort + '\'' + ", hostAndTlsPort='" + this.hostAndTlsPort + '\'' + ", maxSize=" + this.maxSize + ", tier='" + this.tier + '\'' + ", type=" + (Object)((Object)this.type) + ", priority=" + this.priority + '}';
    }
}

