/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordination;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.server.coordination.ChangeRequestHistory;

public final class ChangeRequestsSnapshot<T> {
    private final boolean resetCounter;
    @Nullable
    private final String resetCause;
    @Nullable
    private final ChangeRequestHistory.Counter counter;
    @Nullable
    private final List<T> requests;

    public static <T> ChangeRequestsSnapshot<T> success(ChangeRequestHistory.Counter counter, List<T> requests) {
        return new ChangeRequestsSnapshot<T>(false, null, counter, requests);
    }

    public static <T> ChangeRequestsSnapshot<T> fail(String resetCause) {
        return new ChangeRequestsSnapshot<T>(true, resetCause, null, null);
    }

    @JsonCreator
    public ChangeRequestsSnapshot(@JsonProperty(value="resetCounter") boolean resetCounter, @JsonProperty(value="resetCause") @Nullable String resetCause, @JsonProperty(value="counter") @Nullable ChangeRequestHistory.Counter counter, @JsonProperty(value="requests") @Nullable List<T> requests) {
        this.resetCounter = resetCounter;
        this.resetCause = resetCause;
        if (resetCounter) {
            Preconditions.checkNotNull(resetCause, "NULL resetCause when resetCounter is true.");
        }
        this.counter = counter;
        this.requests = requests;
    }

    @JsonProperty
    public boolean isResetCounter() {
        return this.resetCounter;
    }

    @Nullable
    @JsonProperty
    public String getResetCause() {
        return this.resetCause;
    }

    @Nullable
    @JsonProperty
    public ChangeRequestHistory.Counter getCounter() {
        return this.counter;
    }

    @Nullable
    @JsonProperty
    public List<T> getRequests() {
        return this.requests;
    }

    public String toString() {
        return "ChangeRequestsSnapshot{resetCounter=" + this.resetCounter + ", resetCause='" + this.resetCause + '\'' + ", counter=" + this.counter + ", requests=" + this.requests + '}';
    }
}

