/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.audit;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.audit.AuditEntry;
import org.apache.hive.druid.org.apache.druid.audit.AuditManager;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.org.apache.druid.server.audit.SQLAuditManagerConfig;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;

@ManageLifecycle
public class SQLAuditManager
implements AuditManager {
    private final IDBI dbi;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final ServiceEmitter emitter;
    private final ObjectMapper jsonMapper;
    private final SQLAuditManagerConfig config;

    @Inject
    public SQLAuditManager(SQLMetadataConnector connector, Supplier<MetadataStorageTablesConfig> dbTables, ServiceEmitter emitter, @Json ObjectMapper jsonMapper, SQLAuditManagerConfig config) {
        this.dbi = connector.getDBI();
        this.dbTables = dbTables;
        this.emitter = emitter;
        this.jsonMapper = jsonMapper;
        this.config = config;
    }

    public String getAuditTable() {
        return this.dbTables.get().getAuditTable();
    }

    @Override
    public void doAudit(final AuditEntry auditEntry) {
        this.dbi.withHandle(new HandleCallback<Void>(){

            @Override
            public Void withHandle(Handle handle) throws Exception {
                SQLAuditManager.this.doAudit(auditEntry, handle);
                return null;
            }
        });
    }

    @Override
    public void doAudit(AuditEntry auditEntry, Handle handle) throws IOException {
        this.emitter.emit(new ServiceMetricEvent.Builder().setDimension("key", auditEntry.getKey()).setDimension("type", auditEntry.getType()).setDimension("author", auditEntry.getAuditInfo().getAuthor()).build("config/audit", 1));
        ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %s ( audit_key, type, author, comment, created_date, payload) VALUES (:audit_key, :type, :author, :comment, :created_date, :payload)", this.getAuditTable())).bind("audit_key", auditEntry.getKey())).bind("type", auditEntry.getType())).bind("author", auditEntry.getAuditInfo().getAuthor())).bind("comment", auditEntry.getAuditInfo().getComment())).bind("created_date", auditEntry.getAuditTime().toString())).bind("payload", this.jsonMapper.writeValueAsBytes(auditEntry))).execute();
    }

    @Override
    public List<AuditEntry> fetchAuditHistory(String key, String type, Interval interval) {
        Interval theInterval = this.getIntervalOrDefault(interval);
        return this.dbi.withHandle(handle -> ((Query)((Query)((Query)((Query)handle.createQuery(StringUtils.format("SELECT payload FROM %s WHERE audit_key = :audit_key and type = :type and created_date between :start_date and :end_date ORDER BY created_date", this.getAuditTable())).bind("audit_key", key)).bind("type", type)).bind("start_date", theInterval.getStart().toString())).bind("end_date", theInterval.getEnd().toString())).map((index, r, ctx) -> JacksonUtils.readValue(this.jsonMapper, r.getBytes("payload"), AuditEntry.class)).list());
    }

    private Interval getIntervalOrDefault(Interval interval) {
        Interval theInterval;
        if (interval == null) {
            DateTime now = DateTimes.nowUtc();
            theInterval = new Interval((ReadableInstant)now.minus(this.config.getAuditHistoryMillis()), (ReadableInstant)now);
        } else {
            theInterval = interval;
        }
        return theInterval;
    }

    private int getLimit(int limit) throws IllegalArgumentException {
        if (limit < 1) {
            throw new IllegalArgumentException("Limit must be greater than zero!");
        }
        return limit;
    }

    @Override
    public List<AuditEntry> fetchAuditHistory(String type, Interval interval) {
        Interval theInterval = this.getIntervalOrDefault(interval);
        return this.dbi.withHandle(handle -> ((Query)((Query)((Query)handle.createQuery(StringUtils.format("SELECT payload FROM %s WHERE type = :type and created_date between :start_date and :end_date ORDER BY created_date", this.getAuditTable())).bind("type", type)).bind("start_date", theInterval.getStart().toString())).bind("end_date", theInterval.getEnd().toString())).map((index, r, ctx) -> JacksonUtils.readValue(this.jsonMapper, r.getBytes("payload"), AuditEntry.class)).list());
    }

    @Override
    public List<AuditEntry> fetchAuditHistory(String key, String type, int limit) throws IllegalArgumentException {
        return this.fetchAuditHistoryLastEntries(key, type, limit);
    }

    @Override
    public List<AuditEntry> fetchAuditHistory(String type, int limit) throws IllegalArgumentException {
        return this.fetchAuditHistoryLastEntries(null, type, limit);
    }

    private List<AuditEntry> fetchAuditHistoryLastEntries(String key, String type, int limit) throws IllegalArgumentException {
        int theLimit = this.getLimit(limit);
        String queryString = StringUtils.format("SELECT payload FROM %s WHERE type = :type", this.getAuditTable());
        if (key != null) {
            queryString = queryString + " and audit_key = :audit_key";
        }
        String theQueryString = queryString = queryString + " ORDER BY created_date DESC";
        return this.dbi.withHandle(handle -> {
            Query<Map<String, Object>> query = handle.createQuery(theQueryString);
            if (key != null) {
                query.bind("audit_key", key);
            }
            return ((Query)query.bind("type", type)).setMaxRows(theLimit).map((index, r, ctx) -> JacksonUtils.readValue(this.jsonMapper, r.getBytes("payload"), AuditEntry.class)).list();
        });
    }
}

