/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.org.apache.druid.client.DirectDruidClient;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielders;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryContexts;
import org.apache.hive.druid.org.apache.druid.query.QueryInterruptedException;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.server.QueryLifecycle;
import org.apache.hive.druid.org.apache.druid.server.QueryLifecycleFactory;
import org.apache.hive.druid.org.apache.druid.server.QueryManager;
import org.apache.hive.druid.org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.hive.druid.org.apache.druid.server.security.Access;
import org.apache.hive.druid.org.apache.druid.server.security.AuthConfig;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizationUtils;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.org.apache.druid.server.security.ForbiddenException;
import org.joda.time.DateTime;

@LazySingleton
@Path(value="/druid/v2/")
public class QueryResource
implements QueryCountStatsProvider {
    protected static final EmittingLogger log = new EmittingLogger(QueryResource.class);
    @Deprecated
    protected static final String APPLICATION_SMILE = "application/smile";
    protected static final int RESPONSE_CTX_HEADER_LEN_LIMIT = 7168;
    public static final String HEADER_RESPONSE_CONTEXT = "X-Druid-Response-Context";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_ETAG = "ETag";
    protected final QueryLifecycleFactory queryLifecycleFactory;
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    protected final ObjectMapper serializeDateTimeAsLongJsonMapper;
    protected final ObjectMapper serializeDateTimeAsLongSmileMapper;
    protected final QueryManager queryManager;
    protected final AuthConfig authConfig;
    protected final AuthorizerMapper authorizerMapper;
    private final GenericQueryMetricsFactory queryMetricsFactory;
    private final AtomicLong successfulQueryCount = new AtomicLong();
    private final AtomicLong failedQueryCount = new AtomicLong();
    private final AtomicLong interruptedQueryCount = new AtomicLong();

    @Inject
    public QueryResource(QueryLifecycleFactory queryLifecycleFactory, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryManager queryManager, AuthConfig authConfig, AuthorizerMapper authorizerMapper, GenericQueryMetricsFactory queryMetricsFactory) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.serializeDateTimeAsLongJsonMapper = this.serializeDataTimeAsLong(jsonMapper);
        this.serializeDateTimeAsLongSmileMapper = this.serializeDataTimeAsLong(smileMapper);
        this.queryManager = queryManager;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String queryId, @Context HttpServletRequest req) {
        Access authResult;
        Set<String> datasources;
        if (log.isDebugEnabled()) {
            log.debug("Received cancel request for query [%s]", queryId);
        }
        if ((datasources = this.queryManager.getQueryDatasources(queryId)) == null) {
            log.warn("QueryId [%s] not registered with QueryManager, cannot cancel", queryId);
            datasources = new TreeSet<String>();
        }
        if (!(authResult = AuthorizationUtils.authorizeAllResourceActions(req, Iterables.transform(datasources, AuthorizationUtils.DATASOURCE_WRITE_RA_GENERATOR), this.authorizerMapper)).isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        this.queryManager.cancelQuery(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    public Response doPost(InputStream in, @QueryParam(value="pretty") String pretty, final @Context HttpServletRequest req) throws IOException {
        final QueryLifecycle queryLifecycle = this.queryLifecycleFactory.factorize();
        Query query = null;
        String acceptHeader = req.getHeader("Accept");
        if (Strings.isNullOrEmpty(acceptHeader)) {
            acceptHeader = req.getContentType();
        }
        ResourceIOReaderWriter ioReaderWriter = this.createResourceIOReaderWriter(acceptHeader, pretty != null);
        final String currThreadName = Thread.currentThread().getName();
        try {
            Access authResult;
            queryLifecycle.initialize(this.readQuery(req, in, ioReaderWriter));
            query = queryLifecycle.getQuery();
            String queryId = query.getId();
            String queryThreadName = StringUtils.format("%s[%s_%s_%s]", currThreadName, query.getType(), query.getDataSource().getNames(), queryId);
            Thread.currentThread().setName(queryThreadName);
            if (log.isDebugEnabled()) {
                log.debug("Got query [%s]", query);
            }
            if (!(authResult = queryLifecycle.authorize(req)).isAllowed()) {
                throw new ForbiddenException(authResult.toString());
            }
            QueryLifecycle.QueryResponse queryResponse = queryLifecycle.execute();
            Sequence results = queryResponse.getResults();
            ResponseContext responseContext = queryResponse.getResponseContext();
            String prevEtag = QueryResource.getPreviousEtag(req);
            if (prevEtag != null && prevEtag.equals(responseContext.get(ResponseContext.Key.ETAG))) {
                queryLifecycle.emitLogsAndMetrics(null, req.getRemoteAddr(), -1L);
                this.successfulQueryCount.incrementAndGet();
                Response response = Response.notModified().build();
                return response;
            }
            final Yielder yielder = Yielders.each(results);
            try {
                boolean shouldFinalize = QueryContexts.isFinalize(query, true);
                boolean serializeDateTimeAsLong = QueryContexts.isSerializeDateTimeAsLong(query, false) || !shouldFinalize && QueryContexts.isSerializeDateTimeAsLongInner(query, false);
                final ObjectWriter jsonWriter = ioReaderWriter.newOutputWriter(queryLifecycle.getToolChest(), queryLifecycle.getQuery(), serializeDateTimeAsLong);
                Response.ResponseBuilder responseBuilder = Response.ok((Object)new StreamingOutput(){

                    public void write(OutputStream outputStream) throws WebApplicationException {
                        Exception e = null;
                        CountingOutputStream os = new CountingOutputStream(outputStream);
                        try {
                            jsonWriter.writeValue(os, (Object)yielder);
                            os.flush();
                            os.close();
                        }
                        catch (Exception ex) {
                            e = ex;
                            log.noStackTrace().error(ex, "Unable to send query response.", new Object[0]);
                            throw new RuntimeException(ex);
                        }
                        finally {
                            Thread.currentThread().setName(currThreadName);
                            queryLifecycle.emitLogsAndMetrics(e, req.getRemoteAddr(), os.getCount());
                            if (e == null) {
                                QueryResource.this.successfulQueryCount.incrementAndGet();
                            } else {
                                QueryResource.this.failedQueryCount.incrementAndGet();
                            }
                        }
                    }
                }, (String)ioReaderWriter.getContentType()).header("X-Druid-Query-Id", (Object)queryId);
                Object entityTag = responseContext.remove(ResponseContext.Key.ETAG);
                if (entityTag != null) {
                    responseBuilder.header(HEADER_ETAG, entityTag);
                }
                DirectDruidClient.removeMagicResponseContextFields(responseContext);
                ResponseContext.SerializationResult serializationResult = responseContext.serializeWith(this.jsonMapper, 7168);
                if (serializationResult.isReduced().booleanValue()) {
                    log.info("Response Context truncated for id [%s] . Full context is [%s].", queryId, serializationResult.getFullResult());
                }
                Response response = responseBuilder.header(HEADER_RESPONSE_CONTEXT, (Object)serializationResult.getTruncatedResult()).build();
                return response;
            }
            catch (Exception e) {
                Response response;
                try {
                    yielder.close();
                    throw new RuntimeException(e);
                }
                catch (QueryInterruptedException e2) {
                    this.interruptedQueryCount.incrementAndGet();
                    queryLifecycle.emitLogsAndMetrics(e2, req.getRemoteAddr(), -1L);
                    response = ioReaderWriter.gotError(e2);
                    return response;
                }
                catch (ForbiddenException e3) {
                    throw e3;
                }
                catch (Exception e4) {
                    this.failedQueryCount.incrementAndGet();
                    queryLifecycle.emitLogsAndMetrics(e4, req.getRemoteAddr(), -1L);
                    log.noStackTrace().makeAlert(e4, "Exception handling request", new Object[0]).addData("query", query != null ? this.jsonMapper.writeValueAsString(query) : "unparseable query").addData("peer", req.getRemoteAddr()).emit();
                    response = ioReaderWriter.gotError(e4);
                    return response;
                }
            }
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    private Query<?> readQuery(HttpServletRequest req, InputStream in, ResourceIOReaderWriter ioReaderWriter) throws IOException {
        Query baseQuery = ioReaderWriter.getInputMapper().readValue(in, Query.class);
        String prevEtag = QueryResource.getPreviousEtag(req);
        if (prevEtag != null) {
            baseQuery = baseQuery.withOverriddenContext(ImmutableMap.of(HEADER_IF_NONE_MATCH, prevEtag));
        }
        return baseQuery;
    }

    private static String getPreviousEtag(HttpServletRequest req) {
        return req.getHeader(HEADER_IF_NONE_MATCH);
    }

    protected ObjectMapper serializeDataTimeAsLong(ObjectMapper mapper) {
        return mapper.copy().registerModule(new SimpleModule().addSerializer(DateTime.class, new DateTimeSerializer()));
    }

    protected ResourceIOReaderWriter createResourceIOReaderWriter(String requestType, boolean pretty) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType) || APPLICATION_SMILE.equals(requestType);
        String contentType = isSmile ? "application/x-jackson-smile" : "application/json";
        return new ResourceIOReaderWriter(contentType, isSmile ? this.smileMapper : this.jsonMapper, isSmile ? this.serializeDateTimeAsLongSmileMapper : this.serializeDateTimeAsLongJsonMapper, pretty);
    }

    @Override
    public long getSuccessfulQueryCount() {
        return this.successfulQueryCount.get();
    }

    @Override
    public long getFailedQueryCount() {
        return this.failedQueryCount.get();
    }

    @Override
    public long getInterruptedQueryCount() {
        return this.interruptedQueryCount.get();
    }

    protected static class ResourceIOReaderWriter {
        private final String contentType;
        private final ObjectMapper inputMapper;
        private final ObjectMapper serializeDateTimeAsLongInputMapper;
        private final boolean isPretty;

        ResourceIOReaderWriter(String contentType, ObjectMapper inputMapper, ObjectMapper serializeDateTimeAsLongInputMapper, boolean isPretty) {
            this.contentType = contentType;
            this.inputMapper = inputMapper;
            this.serializeDateTimeAsLongInputMapper = serializeDateTimeAsLongInputMapper;
            this.isPretty = isPretty;
        }

        String getContentType() {
            return this.contentType;
        }

        ObjectMapper getInputMapper() {
            return this.inputMapper;
        }

        ObjectWriter newOutputWriter(@Nullable QueryToolChest toolChest, @Nullable Query query, boolean serializeDateTimeAsLong) {
            ObjectMapper mapper = serializeDateTimeAsLong ? this.serializeDateTimeAsLongInputMapper : this.inputMapper;
            ObjectMapper decoratedMapper = toolChest != null ? toolChest.decorateObjectMapper(mapper, Preconditions.checkNotNull(query, "query")) : mapper;
            return this.isPretty ? decoratedMapper.writerWithDefaultPrettyPrinter() : decoratedMapper.writer();
        }

        Response ok(Object object) throws IOException {
            return Response.ok((Object)this.newOutputWriter(null, null, false).writeValueAsString(object), (String)this.contentType).build();
        }

        Response gotError(Exception e) throws IOException {
            return Response.serverError().type(this.contentType).entity((Object)this.newOutputWriter(null, null, false).writeValueAsBytes(QueryInterruptedException.wrapIfNeeded(e))).build();
        }
    }
}

