/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.HashMultimap;
import org.apache.hive.druid.com.google.common.collect.Multimaps;
import org.apache.hive.druid.com.google.common.collect.SetMultimap;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryWatcher;

public class QueryManager
implements QueryWatcher {
    private final SetMultimap<String, ListenableFuture> queries = Multimaps.synchronizedSetMultimap(HashMultimap.create());
    private final SetMultimap<String, String> queryDatasources = Multimaps.synchronizedSetMultimap(HashMultimap.create());

    public boolean cancelQuery(String id) {
        this.queryDatasources.removeAll(id);
        Set<ListenableFuture> futures = this.queries.removeAll(id);
        boolean success = true;
        for (ListenableFuture future : futures) {
            success = success && future.cancel(true);
        }
        return success;
    }

    @Override
    public void registerQuery(Query query, final ListenableFuture future) {
        final String id = query.getId();
        final List<String> datasources = query.getDataSource().getNames();
        this.queries.put(id, future);
        this.queryDatasources.putAll(id, datasources);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                QueryManager.this.queries.remove(id, future);
                for (String datasource : datasources) {
                    QueryManager.this.queryDatasources.remove(id, datasource);
                }
            }
        }, Execs.directExecutor());
    }

    public Set<String> getQueryDatasources(String queryId) {
        return this.queryDatasources.get(queryId);
    }
}

