/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import com.google.inject.name.Named;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.org.apache.druid.common.utils.SocketUtil;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;

public class DruidNode {
    @JsonProperty(value="service")
    @NotNull
    private String serviceName;
    @JsonProperty
    @NotNull
    private String host;
    @JsonProperty
    private boolean bindOnHost = false;
    @Deprecated
    @JsonProperty
    @Max(value=65535L)
    private int port = -1;
    @JsonProperty
    @Max(value=65535L)
    private int plaintextPort = -1;
    @JsonProperty
    private boolean enablePlaintextPort = true;
    @JsonProperty
    @Max(value=65535L)
    private int tlsPort = -1;
    @JsonProperty
    private boolean enableTlsPort = false;

    public DruidNode(String serviceName, String host, boolean bindOnHost, Integer plaintextPort, Integer tlsPort, boolean enablePlaintextPort, boolean enableTlsPort) {
        this(serviceName, host, bindOnHost, plaintextPort, null, tlsPort, enablePlaintextPort, enableTlsPort);
    }

    @JsonCreator
    public DruidNode(@JacksonInject @Named(value="serviceName") @JsonProperty(value="service") String serviceName, @JsonProperty(value="host") String host, @JsonProperty(value="bindOnHost") boolean bindOnHost, @JsonProperty(value="plaintextPort") Integer plaintextPort, @JacksonInject @Named(value="servicePort") @JsonProperty(value="port") Integer port, @JacksonInject @Named(value="tlsServicePort") @JsonProperty(value="tlsPort") Integer tlsPort, @JsonProperty(value="enablePlaintextPort") Boolean enablePlaintextPort, @JsonProperty(value="enableTlsPort") boolean enableTlsPort) {
        this.init(serviceName, host, bindOnHost, plaintextPort != null ? plaintextPort : port, tlsPort, enablePlaintextPort == null ? true : enablePlaintextPort, enableTlsPort);
    }

    private void init(String serviceName, String host, boolean bindOnHost, Integer plainTextPort, Integer tlsPort, boolean enablePlaintextPort, boolean enableTlsPort) {
        boolean nullHost;
        Preconditions.checkNotNull(serviceName);
        if (!enableTlsPort && !enablePlaintextPort) {
            throw new IAE("At least one of the druid.enablePlaintextPort or druid.enableTlsPort needs to be true.", new Object[0]);
        }
        this.enablePlaintextPort = enablePlaintextPort;
        this.enableTlsPort = enableTlsPort;
        boolean bl = nullHost = host == null;
        if (host != null) {
            Integer portFromHostConfig;
            HostAndPort hostAndPort = HostAndPort.fromString(host);
            host = hostAndPort.getHostText();
            Integer n = portFromHostConfig = hostAndPort.hasPort() ? Integer.valueOf(hostAndPort.getPort()) : null;
            if (plainTextPort != null && portFromHostConfig != null && !plainTextPort.equals(portFromHostConfig)) {
                throw new IAE("Conflicting host:port [%s] and port [%d] settings", host, plainTextPort);
            }
            if (portFromHostConfig != null) {
                plainTextPort = portFromHostConfig;
            }
        } else {
            host = DruidNode.getDefaultHost();
        }
        if (enablePlaintextPort && enableTlsPort && (plainTextPort == null || tlsPort == null || plainTextPort.equals(tlsPort))) {
            throw new IAE("plaintextPort and tlsPort cannot be null or same if both http and https connectors are enabled", new Object[0]);
        }
        if (enableTlsPort && (tlsPort == null || tlsPort < 0)) {
            throw new IAE("A valid tlsPort needs to specified when druid.enableTlsPort is set", new Object[0]);
        }
        if (enablePlaintextPort) {
            if (nullHost && plainTextPort == null) {
                plainTextPort = -1;
            } else if (plainTextPort == null) {
                plainTextPort = SocketUtil.findOpenPort(8080);
            }
            this.plaintextPort = plainTextPort;
        } else {
            this.plaintextPort = -1;
        }
        this.tlsPort = enableTlsPort ? tlsPort : -1;
        this.serviceName = serviceName;
        this.host = host;
        this.bindOnHost = bindOnHost;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isBindOnHost() {
        return this.bindOnHost;
    }

    public int getPlaintextPort() {
        return this.plaintextPort;
    }

    public boolean isEnablePlaintextPort() {
        return this.enablePlaintextPort;
    }

    public boolean isEnableTlsPort() {
        return this.enableTlsPort;
    }

    public int getTlsPort() {
        return this.tlsPort;
    }

    public DruidNode withService(String service) {
        return new DruidNode(service, this.host, this.bindOnHost, this.plaintextPort, this.tlsPort, this.enablePlaintextPort, this.enableTlsPort);
    }

    public String getServiceScheme() {
        return this.tlsPort >= 0 ? "https" : "http";
    }

    public String getHostAndPort() {
        if (this.enablePlaintextPort) {
            if (this.plaintextPort < 0) {
                return HostAndPort.fromString(this.host).toString();
            }
            return HostAndPort.fromParts(this.host, this.plaintextPort).toString();
        }
        return null;
    }

    public String getHostAndTlsPort() {
        if (this.enableTlsPort) {
            return HostAndPort.fromParts(this.host, this.tlsPort).toString();
        }
        return null;
    }

    public int getPortToUse() {
        if (this.enableTlsPort) {
            return this.getTlsPort();
        }
        return this.getPlaintextPort();
    }

    public String getHostAndPortToUse() {
        return this.getHostAndTlsPort() != null ? this.getHostAndTlsPort() : this.getHostAndPort();
    }

    public URI getUriToUse() {
        try {
            return new URI(this.getServiceScheme(), null, this.host, this.getPortToUse(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDefaultHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new ISE(e, "Unable to determine host name", new Object[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidNode druidNode = (DruidNode)o;
        return this.port == druidNode.port && this.bindOnHost == druidNode.bindOnHost && this.plaintextPort == druidNode.plaintextPort && this.enablePlaintextPort == druidNode.enablePlaintextPort && this.tlsPort == druidNode.tlsPort && this.enableTlsPort == druidNode.enableTlsPort && Objects.equals(this.serviceName, druidNode.serviceName) && Objects.equals(this.host, druidNode.host);
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.host, this.port, this.plaintextPort, this.enablePlaintextPort, this.tlsPort, this.enableTlsPort);
    }

    public String toString() {
        return "DruidNode{serviceName='" + this.serviceName + '\'' + ", host='" + this.host + '\'' + ", bindOnHost=" + this.bindOnHost + ", port=" + this.port + ", plaintextPort=" + this.plaintextPort + ", enablePlaintextPort=" + this.enablePlaintextPort + ", tlsPort=" + this.tlsPort + ", enableTlsPort=" + this.enableTlsPort + '}';
    }
}

