/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.druid.client.DruidDataSource;
import org.apache.hive.druid.org.apache.druid.client.FilteredServerInventoryView;
import org.apache.hive.druid.org.apache.druid.client.ServerViewUtil;
import org.apache.hive.druid.org.apache.druid.client.TimelineServerView;
import org.apache.hive.druid.org.apache.druid.client.selector.ServerSelector;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.JodaUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.query.LocatedSegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.hive.druid.org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.hive.druid.org.apache.druid.server.security.AuthConfig;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizationUtils;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineLookup;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

@Path(value="/druid/v2/datasources")
public class ClientInfoResource {
    private static final Logger log = new Logger(ClientInfoResource.class);
    private static final String KEY_DIMENSIONS = "dimensions";
    private static final String KEY_METRICS = "metrics";
    private FilteredServerInventoryView serverInventoryView;
    private TimelineServerView timelineServerView;
    private SegmentMetadataQueryConfig segmentMetadataQueryConfig;
    private final AuthConfig authConfig;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public ClientInfoResource(FilteredServerInventoryView serverInventoryView, TimelineServerView timelineServerView, SegmentMetadataQueryConfig segmentMetadataQueryConfig, AuthConfig authConfig, AuthorizerMapper authorizerMapper) {
        this.serverInventoryView = serverInventoryView;
        this.timelineServerView = timelineServerView;
        this.segmentMetadataQueryConfig = segmentMetadataQueryConfig == null ? new SegmentMetadataQueryConfig() : segmentMetadataQueryConfig;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Produces(value={"application/json"})
    public Iterable<String> getDataSources(@Context HttpServletRequest request) {
        Function raGenerator = datasourceName -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((String)datasourceName));
        return AuthorizationUtils.filterAuthorizedResources(request, this.getAllDataSources(), raGenerator, this.authorizerMapper);
    }

    private Set<String> getAllDataSources() {
        return this.serverInventoryView.getInventory().stream().flatMap(server -> server.getDataSources().stream().map(DruidDataSource::getName)).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Map<String, Object> getDatasource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval, @QueryParam(value="full") String full) {
        void var9_11;
        List<TimelineObjectHolder<String, ServerSelector>> serversLookup;
        Interval theInterval;
        if (full == null) {
            return ImmutableMap.of(KEY_DIMENSIONS, this.getDataSourceDimensions(dataSourceName, interval), KEY_METRICS, this.getDataSourceMetrics(dataSourceName, interval));
        }
        if (interval == null || interval.isEmpty()) {
            DateTime now = this.getCurrentTime();
            theInterval = new Interval((ReadablePeriod)this.segmentMetadataQueryConfig.getDefaultHistory(), (ReadableInstant)now);
        } else {
            theInterval = Intervals.of(interval);
        }
        TimelineLookup<String, ServerSelector> timeline = this.timelineServerView.getTimeline(new TableDataSource(dataSourceName));
        List<TimelineObjectHolder<String, ServerSelector>> list = serversLookup = timeline != null ? timeline.lookup(theInterval) : null;
        if (serversLookup == null || Iterables.isEmpty(serversLookup)) {
            return Collections.EMPTY_MAP;
        }
        TreeMap servedIntervals = new TreeMap(new Comparator<Interval>(){

            @Override
            public int compare(Interval o1, Interval o2) {
                if (o1.equals((Object)o2) || o1.overlaps((ReadableInterval)o2)) {
                    return 0;
                }
                return o1.isBefore((ReadableInterval)o2) ? -1 : 1;
            }
        });
        for (TimelineObjectHolder timelineObjectHolder : serversLookup) {
            HashSet<String> dimensions = new HashSet<String>();
            HashSet<String> metrics = new HashSet<String>();
            PartitionHolder partitionHolder = timelineObjectHolder.getObject();
            if (partitionHolder.isComplete()) {
                for (ServerSelector server : partitionHolder.payloads()) {
                    DataSegment segment = server.getSegment();
                    dimensions.addAll(segment.getDimensions());
                    metrics.addAll(segment.getMetrics());
                }
            }
            servedIntervals.put(timelineObjectHolder.getInterval(), ImmutableMap.of(KEY_DIMENSIONS, dimensions, KEY_METRICS, metrics));
        }
        LinkedHashMap<String, Object> result = Maps.newLinkedHashMap();
        Object var9_10 = null;
        Map cols = null;
        for (Map.Entry e : servedIntervals.entrySet()) {
            Interval ival = (Interval)e.getKey();
            if (var9_11 != null && var9_11.abuts((ReadableInterval)ival) && cols.equals(e.getValue())) {
                Interval interval2 = var9_11.withEnd((ReadableInstant)ival.getEnd());
                continue;
            }
            if (var9_11 != null) {
                result.put(var9_11.toString(), cols);
            }
            Interval interval3 = ival;
            cols = (Map)e.getValue();
        }
        if (var9_11 != null) {
            result.put(var9_11.toString(), cols);
        }
        return result;
    }

    @Deprecated
    @GET
    @Path(value="/{dataSourceName}/dimensions")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Iterable<String> getDataSourceDimensions(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval) {
        Interval theInterval;
        Set<DataSegment> segments = this.getAllSegmentsForDataSource(dataSourceName);
        if (interval == null || interval.isEmpty()) {
            DateTime now = this.getCurrentTime();
            theInterval = new Interval((ReadablePeriod)this.segmentMetadataQueryConfig.getDefaultHistory(), (ReadableInstant)now);
        } else {
            theInterval = Intervals.of(interval);
        }
        HashSet<String> dims = new HashSet<String>();
        for (DataSegment segment : segments) {
            if (!theInterval.overlaps((ReadableInterval)segment.getInterval())) continue;
            dims.addAll(segment.getDimensions());
        }
        return dims;
    }

    @Deprecated
    @GET
    @Path(value="/{dataSourceName}/metrics")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Iterable<String> getDataSourceMetrics(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval) {
        Interval theInterval;
        Set<DataSegment> segments = this.getAllSegmentsForDataSource(dataSourceName);
        if (interval == null || interval.isEmpty()) {
            DateTime now = this.getCurrentTime();
            theInterval = new Interval((ReadablePeriod)this.segmentMetadataQueryConfig.getDefaultHistory(), (ReadableInstant)now);
        } else {
            theInterval = Intervals.of(interval);
        }
        HashSet<String> metrics = new HashSet<String>();
        for (DataSegment segment : segments) {
            if (!theInterval.overlaps((ReadableInterval)segment.getInterval())) continue;
            metrics.addAll(segment.getMetrics());
        }
        return metrics;
    }

    private Set<DataSegment> getAllSegmentsForDataSource(String dataSourceName) {
        return this.serverInventoryView.getInventory().stream().flatMap(server -> {
            DruidDataSource dataSource = server.getDataSource(dataSourceName);
            if (dataSource == null) {
                return Stream.empty();
            }
            return dataSource.getSegments().stream();
        }).collect(Collectors.toSet());
    }

    @GET
    @Path(value="/{dataSourceName}/candidates")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Iterable<LocatedSegmentDescriptor> getQueryTargets(@PathParam(value="dataSourceName") String datasource, @QueryParam(value="intervals") String intervals, @QueryParam(value="numCandidates") @DefaultValue(value="-1") int numCandidates, @Context HttpServletRequest req) {
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        for (String interval : intervals.split(",")) {
            intervalList.add(Intervals.of(interval.trim()));
        }
        ArrayList<Interval> condensed = JodaUtils.condenseIntervals(intervalList);
        return ServerViewUtil.getTargetLocations(this.timelineServerView, datasource, condensed, numCandidates);
    }

    protected DateTime getCurrentTime() {
        return DateTimes.nowUtc();
    }
}

