/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.virtual;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;

public class VirtualizedColumnSelectorFactory
implements ColumnSelectorFactory {
    private final ColumnSelectorFactory baseFactory;
    private final VirtualColumns virtualColumns;

    public VirtualizedColumnSelectorFactory(ColumnSelectorFactory baseFactory, VirtualColumns virtualColumns) {
        this.baseFactory = Preconditions.checkNotNull(baseFactory, "baseFactory");
        this.virtualColumns = Preconditions.checkNotNull(virtualColumns, "virtualColumns");
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this.baseFactory);
        }
        return this.baseFactory.makeDimensionSelector(dimensionSpec);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this.baseFactory);
        }
        return this.baseFactory.makeColumnValueSelector(columnName);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return this.baseFactory.getColumnCapabilities(columnName);
    }
}

