/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.vector;

import org.apache.hive.druid.org.apache.druid.segment.vector.VectorOffset;

public class NoFilterVectorOffset
implements VectorOffset {
    private final int maxVectorSize;
    private final int start;
    private final int end;
    private int theOffset;

    public NoFilterVectorOffset(int maxVectorSize, int start, int end) {
        this.maxVectorSize = maxVectorSize;
        this.start = start;
        this.end = end;
        this.reset();
    }

    @Override
    public int getId() {
        return this.theOffset;
    }

    @Override
    public void advance() {
        this.theOffset += this.maxVectorSize;
    }

    @Override
    public boolean isDone() {
        return this.theOffset >= this.end;
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public int getMaxVectorSize() {
        return this.maxVectorSize;
    }

    @Override
    public int getCurrentVectorSize() {
        return Math.min(this.maxVectorSize, this.end - this.theOffset);
    }

    @Override
    public int getStartOffset() {
        return this.theOffset;
    }

    @Override
    public int[] getOffsets() {
        throw new UnsupportedOperationException("no filter");
    }

    @Override
    public void reset() {
        this.theOffset = this.start;
    }
}

