/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.vector;

import org.apache.hive.druid.org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public abstract class BaseFloatVectorValueSelector
implements VectorValueSelector {
    protected final ReadableVectorOffset offset;
    private int longId = -1;
    private int doubleId = -1;
    private long[] longVector;
    private double[] doubleVector;

    public BaseFloatVectorValueSelector(ReadableVectorOffset offset) {
        this.offset = offset;
    }

    @Override
    public int getCurrentVectorSize() {
        return this.offset.getCurrentVectorSize();
    }

    @Override
    public int getMaxVectorSize() {
        return this.offset.getMaxVectorSize();
    }

    @Override
    public long[] getLongVector() {
        if (this.longId == this.offset.getId()) {
            return this.longVector;
        }
        if (this.longVector == null) {
            this.longVector = new long[this.offset.getMaxVectorSize()];
        }
        float[] floatVector = this.getFloatVector();
        for (int i = 0; i < this.getCurrentVectorSize(); ++i) {
            this.longVector[i] = (long)floatVector[i];
        }
        this.longId = this.offset.getId();
        return this.longVector;
    }

    @Override
    public double[] getDoubleVector() {
        if (this.doubleId == this.offset.getId()) {
            return this.doubleVector;
        }
        if (this.doubleVector == null) {
            this.doubleVector = new double[this.offset.getMaxVectorSize()];
        }
        float[] floatVector = this.getFloatVector();
        for (int i = 0; i < this.getCurrentVectorSize(); ++i) {
            this.doubleVector[i] = floatVector[i];
        }
        this.doubleId = this.offset.getId();
        return this.doubleVector;
    }
}

