/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.data.input.Rows;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.transform.RowFunction;
import org.apache.hive.druid.org.apache.druid.segment.transform.Transform;
import org.apache.hive.druid.org.apache.druid.segment.transform.TransformSpec;
import org.joda.time.DateTime;

public class Transformer {
    private final Map<String, RowFunction> transforms = new HashMap<String, RowFunction>();
    private final ThreadLocal<Row> rowSupplierForValueMatcher = new ThreadLocal();
    private final ValueMatcher valueMatcher;

    Transformer(TransformSpec transformSpec) {
        for (Transform transform : transformSpec.getTransforms()) {
            this.transforms.put(transform.getName(), transform.getRowFunction());
        }
        this.valueMatcher = transformSpec.getFilter() != null ? transformSpec.getFilter().toFilter().makeMatcher(RowBasedColumnSelectorFactory.create(this.rowSupplierForValueMatcher::get, null)) : null;
    }

    @Nullable
    public InputRow transform(@Nullable InputRow row) {
        if (row == null) {
            return null;
        }
        InputRow transformedRow = this.transforms.isEmpty() ? row : new TransformedInputRow(row, this.transforms);
        if (this.valueMatcher != null) {
            this.rowSupplierForValueMatcher.set(transformedRow);
            if (!this.valueMatcher.matches()) {
                return null;
            }
        }
        return transformedRow;
    }

    @Nullable
    public InputRowListPlusRawValues transform(@Nullable InputRowListPlusRawValues row) {
        InputRowListPlusRawValues inputRowListPlusRawValues;
        if (row == null) {
            return null;
        }
        if (this.transforms.isEmpty() || row.getInputRows() == null) {
            inputRowListPlusRawValues = row;
        } else {
            List<InputRow> originalRows = row.getInputRows();
            ArrayList<InputRow> transformedRows = new ArrayList<InputRow>(originalRows.size());
            for (InputRow originalRow : originalRows) {
                transformedRows.add(new TransformedInputRow(originalRow, this.transforms));
            }
            inputRowListPlusRawValues = InputRowListPlusRawValues.of(transformedRows, row.getRawValues());
        }
        if (this.valueMatcher != null && inputRowListPlusRawValues.getInputRows() != null) {
            ArrayList<InputRow> filteredRows = new ArrayList<InputRow>(inputRowListPlusRawValues.getInputRows().size());
            for (InputRow inputRow : inputRowListPlusRawValues.getInputRows()) {
                this.rowSupplierForValueMatcher.set(inputRow);
                if (!this.valueMatcher.matches()) continue;
                filteredRows.add(inputRow);
            }
            return InputRowListPlusRawValues.of(filteredRows, row.getRawValues());
        }
        return inputRowListPlusRawValues;
    }

    public static class TransformedInputRow
    implements InputRow {
        private final InputRow row;
        private final Map<String, RowFunction> transforms;

        public TransformedInputRow(InputRow row, Map<String, RowFunction> transforms) {
            this.row = row;
            this.transforms = transforms;
        }

        @Override
        public List<String> getDimensions() {
            return this.row.getDimensions();
        }

        @Override
        public long getTimestampFromEpoch() {
            RowFunction transform = this.transforms.get("__time");
            if (transform != null) {
                return Rows.objectToNumber("__time", transform.eval(this.row)).longValue();
            }
            return this.row.getTimestampFromEpoch();
        }

        @Override
        public DateTime getTimestamp() {
            RowFunction transform = this.transforms.get("__time");
            if (transform != null) {
                return DateTimes.utc(this.getTimestampFromEpoch());
            }
            return this.row.getTimestamp();
        }

        @Override
        public List<String> getDimension(String dimension) {
            RowFunction transform = this.transforms.get(dimension);
            if (transform != null) {
                return Rows.objectToStrings(transform.eval(this.row));
            }
            return this.row.getDimension(dimension);
        }

        @Override
        public Object getRaw(String column) {
            RowFunction transform = this.transforms.get(column);
            if (transform != null) {
                return transform.eval(this.row);
            }
            return this.row.getRaw(column);
        }

        @Override
        public Number getMetric(String metric) {
            RowFunction transform = this.transforms.get(metric);
            if (transform != null) {
                return Rows.objectToNumber(metric, transform.eval(this.row));
            }
            return this.row.getMetric(metric);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransformedInputRow that = (TransformedInputRow)o;
            return Objects.equals(this.row, that.row) && Objects.equals(this.transforms, that.transforms);
        }

        public int hashCode() {
            return Objects.hash(this.row, this.transforms);
        }

        @Override
        public int compareTo(Row o) {
            return this.row.compareTo(o);
        }

        public String toString() {
            return "TransformedInputRow{row=" + this.row + '}';
        }
    }
}

