/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.serde;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.org.apache.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class LargeColumnSupportedComplexColumnSerializer<T>
implements GenericColumnSerializer<T> {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ObjectStrategy strategy;
    private final int columnSize;
    private GenericIndexedWriter<T> writer;

    public static <T> LargeColumnSupportedComplexColumnSerializer<T> create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy strategy) {
        return new LargeColumnSupportedComplexColumnSerializer<T>(segmentWriteOutMedium, filenameBase, strategy);
    }

    public static <T> LargeColumnSupportedComplexColumnSerializer<T> createWithColumnSize(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy strategy, int columnSize) {
        return new LargeColumnSupportedComplexColumnSerializer<T>(segmentWriteOutMedium, filenameBase, strategy, columnSize);
    }

    private LargeColumnSupportedComplexColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy strategy) {
        this(segmentWriteOutMedium, filenameBase, strategy, Integer.MAX_VALUE);
    }

    private LargeColumnSupportedComplexColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy strategy, int columnSize) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
        this.columnSize = columnSize;
    }

    @Override
    public void open() throws IOException {
        this.writer = new GenericIndexedWriter(this.segmentWriteOutMedium, StringUtils.format("%s.complex_column", this.filenameBase), this.strategy, this.columnSize);
        this.writer.open();
    }

    @Override
    public void serialize(ColumnValueSelector<? extends T> selector) throws IOException {
        this.writer.write(selector.getObject());
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.writeTo(channel, smoosher);
    }
}

