/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.plumber;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheConfig;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.hive.druid.org.apache.druid.common.guava.ThreadRenamingCallable;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.IndexMerger;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.RealtimePlumber;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.Sink;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class FlushingPlumber
extends RealtimePlumber {
    private static final EmittingLogger log = new EmittingLogger(FlushingPlumber.class);
    private final DataSchema schema;
    private final RealtimeTuningConfig config;
    private final Duration flushDuration;
    private volatile ScheduledExecutorService flushScheduledExec = null;
    private volatile boolean stopped = false;

    public FlushingPlumber(Duration flushDuration, DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics, ServiceEmitter emitter, QueryRunnerFactoryConglomerate conglomerate, DataSegmentAnnouncer segmentAnnouncer, ExecutorService queryExecutorService, IndexMerger indexMerger, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats, ObjectMapper objectMapper) {
        super(schema, config, metrics, emitter, conglomerate, segmentAnnouncer, queryExecutorService, null, null, null, indexMerger, indexIO, cache, cacheConfig, cachePopulatorStats, objectMapper);
        this.flushDuration = flushDuration;
        this.schema = schema;
        this.config = config;
    }

    @Override
    public Object startJob() {
        log.info("Starting job for %s", this.getSchema().getDataSource());
        this.computeBaseDir(this.getSchema()).mkdirs();
        this.initializeExecutors();
        if (this.flushScheduledExec == null) {
            this.flushScheduledExec = Execs.scheduledSingleThreaded("flushing_scheduled_%d");
        }
        Object retVal = this.bootstrapSinksFromDisk();
        this.startFlushThread();
        return retVal;
    }

    protected void flushAfterDuration(final long truncatedTime, final Sink sink) {
        log.info("Abandoning segment %s at %s", sink.getSegment().getId(), DateTimes.nowUtc().plusMillis((int)this.flushDuration.getMillis()));
        ScheduledExecutors.scheduleWithFixedDelay(this.flushScheduledExec, this.flushDuration, new Callable<ScheduledExecutors.Signal>(){

            @Override
            public ScheduledExecutors.Signal call() {
                log.info("Abandoning segment %s", sink.getSegment().getId());
                FlushingPlumber.this.abandonSegment(truncatedTime, sink);
                return ScheduledExecutors.Signal.STOP;
            }
        });
    }

    private void startFlushThread() {
        final Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        DateTime truncatedNow = segmentGranularity.bucketStart(DateTimes.nowUtc());
        final long windowMillis = this.config.getWindowPeriod().toStandardDuration().getMillis();
        log.info("Expect to run at [%s]", DateTimes.nowUtc().plus((ReadableDuration)new Duration(System.currentTimeMillis(), this.schema.getGranularitySpec().getSegmentGranularity().increment(truncatedNow).getMillis() + windowMillis)));
        String threadName = StringUtils.format("%s-flusher-%d", this.getSchema().getDataSource(), this.getConfig().getShardSpec().getPartitionNum());
        ThreadRenamingCallable<ScheduledExecutors.Signal> threadRenamingCallable = new ThreadRenamingCallable<ScheduledExecutors.Signal>(threadName){

            @Override
            public ScheduledExecutors.Signal doCall() {
                if (FlushingPlumber.this.stopped) {
                    log.info("Stopping flusher thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                long minTimestamp = segmentGranularity.bucketStart(FlushingPlumber.this.getRejectionPolicy().getCurrMaxTime().minus(windowMillis)).getMillis();
                ArrayList<Map.Entry<Long, Sink>> sinksToPush = new ArrayList<Map.Entry<Long, Sink>>();
                for (Map.Entry<Long, Sink> entry : FlushingPlumber.this.getSinks().entrySet()) {
                    Long intervalStart = entry.getKey();
                    if (intervalStart >= minTimestamp) continue;
                    log.info("Adding entry[%s] to flush.", entry);
                    sinksToPush.add(entry);
                }
                for (Map.Entry<Long, Sink> entry : sinksToPush) {
                    FlushingPlumber.this.flushAfterDuration(entry.getKey(), entry.getValue());
                }
                if (FlushingPlumber.this.stopped) {
                    log.info("Stopping flusher thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                return ScheduledExecutors.Signal.REPEAT;
            }
        };
        Duration initialDelay = new Duration(System.currentTimeMillis(), this.schema.getGranularitySpec().getSegmentGranularity().increment(truncatedNow).getMillis() + windowMillis);
        Duration rate = new Duration((ReadableInstant)truncatedNow, (ReadableInstant)segmentGranularity.increment(truncatedNow));
        ScheduledExecutors.scheduleAtFixedRate(this.flushScheduledExec, initialDelay, rate, (Callable<ScheduledExecutors.Signal>)threadRenamingCallable);
    }

    @Override
    public void finishJob() {
        log.info("Stopping job", new Object[0]);
        for (Map.Entry<Long, Sink> entry : this.getSinks().entrySet()) {
            this.abandonSegment(entry.getKey(), entry.getValue());
        }
        this.shutdownExecutors();
        if (this.flushScheduledExec != null) {
            this.flushScheduledExec.shutdown();
        }
        this.stopped = true;
    }
}

