/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;

public class InlineFirehose
implements Firehose {
    private final StringInputRowParser parser;
    private final LineIterator lineIterator;

    InlineFirehose(String data, StringInputRowParser parser) throws IOException {
        this.parser = parser;
        Charset charset = Charset.forName(parser.getEncoding());
        ByteArrayInputStream stream = new ByteArrayInputStream(data.getBytes(charset));
        this.lineIterator = IOUtils.lineIterator((InputStream)stream, (Charset)charset);
    }

    @Override
    public boolean hasMore() {
        return this.lineIterator.hasNext();
    }

    @Override
    public InputRow nextRow() {
        return this.parser.parse(this.nextRaw());
    }

    private String nextRaw() {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        return this.lineIterator.next();
    }

    @Override
    public InputRowListPlusRawValues nextRowWithRaw() {
        String raw = this.nextRaw();
        try {
            return InputRowListPlusRawValues.of(this.parser.parse(raw), this.parser.parseString(raw));
        }
        catch (ParseException e) {
            return InputRowListPlusRawValues.of(this.parser.parseString(raw), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.lineIterator.close();
    }
}

