/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.FirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;

public class CombiningFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(CombiningFirehoseFactory.class);
    private final List<FirehoseFactory> delegateFactoryList;

    @JsonCreator
    public CombiningFirehoseFactory(@JsonProperty(value="delegates") List<FirehoseFactory> delegateFactoryList) {
        Preconditions.checkArgument(!delegateFactoryList.isEmpty());
        this.delegateFactoryList = delegateFactoryList;
    }

    @Override
    public Firehose connect(InputRowParser parser, File temporaryDirectory) {
        return new CombiningFirehose(parser, temporaryDirectory);
    }

    @JsonProperty(value="delegates")
    public List<FirehoseFactory> getDelegateFactoryList() {
        return this.delegateFactoryList;
    }

    class CombiningFirehose
    implements Firehose {
        private final InputRowParser parser;
        private final File temporaryDirectory;
        private final Iterator<FirehoseFactory> firehoseFactoryIterator;
        private volatile Firehose currentFirehose;

        CombiningFirehose(InputRowParser parser, File temporaryDirectory) {
            this.firehoseFactoryIterator = CombiningFirehoseFactory.this.delegateFactoryList.iterator();
            this.parser = parser;
            this.temporaryDirectory = temporaryDirectory;
            this.nextFirehose();
        }

        private void nextFirehose() {
            if (this.firehoseFactoryIterator.hasNext()) {
                try {
                    if (this.currentFirehose != null) {
                        this.currentFirehose.close();
                    }
                    this.currentFirehose = this.firehoseFactoryIterator.next().connect(this.parser, this.temporaryDirectory);
                }
                catch (IOException e) {
                    if (this.currentFirehose != null) {
                        try {
                            this.currentFirehose.close();
                        }
                        catch (IOException e2) {
                            log.error(e, "Unable to close currentFirehose!", new Object[0]);
                            throw new RuntimeException(e2);
                        }
                    }
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public boolean hasMore() throws IOException {
            return this.currentFirehose.hasMore();
        }

        @Override
        @Nullable
        public InputRow nextRow() throws IOException {
            InputRow rv = this.currentFirehose.nextRow();
            if (!this.currentFirehose.hasMore()) {
                this.nextFirehose();
            }
            return rv;
        }

        @Override
        public void close() throws IOException {
            this.currentFirehose.close();
        }
    }
}

