/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.FirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.segment.realtime.firehose.PredicateFirehose;
import org.joda.time.Interval;

public class ClippedFirehoseFactory
implements FirehoseFactory {
    private final FirehoseFactory delegate;
    private final Interval interval;

    @JsonCreator
    public ClippedFirehoseFactory(@JsonProperty(value="delegate") FirehoseFactory delegate, @JsonProperty(value="interval") Interval interval) {
        this.delegate = delegate;
        this.interval = interval;
    }

    @JsonProperty
    public FirehoseFactory getDelegate() {
        return this.delegate;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    public Firehose connect(InputRowParser parser, File temporaryDirectory) throws IOException {
        return new PredicateFirehose(this.delegate.connect(parser, temporaryDirectory), new Predicate<InputRow>(){

            @Override
            public boolean apply(InputRow input) {
                return ClippedFirehoseFactory.this.interval.contains(input.getTimestampFromEpoch());
            }
        });
    }
}

