/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator;

import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheConfig;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.IndexMerger;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.joda.time.Interval;

public class PeonAppenderatorsManager
implements AppenderatorsManager {
    private Appenderator realtimeAppenderator;
    private Appenderator batchAppenderator;

    @Override
    public Appenderator createRealtimeAppenderatorForTask(String taskId, DataSchema schema, AppenderatorConfig config, FireDepartmentMetrics metrics, DataSegmentPusher dataSegmentPusher, ObjectMapper jsonMapper, IndexIO indexIO, IndexMerger indexMerger, QueryRunnerFactoryConglomerate conglomerate, DataSegmentAnnouncer segmentAnnouncer, ServiceEmitter emitter, ExecutorService queryExecutorService, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats) {
        if (this.realtimeAppenderator != null) {
            throw new ISE("A realtime appenderator was already created for this peon's task.", new Object[0]);
        }
        if (this.batchAppenderator != null) {
            throw new ISE("A batch appenderator was already created for this peon's task.", new Object[0]);
        }
        this.realtimeAppenderator = Appenderators.createRealtime(taskId, schema, config, metrics, dataSegmentPusher, jsonMapper, indexIO, indexMerger, conglomerate, segmentAnnouncer, emitter, queryExecutorService, cache, cacheConfig, cachePopulatorStats);
        return this.realtimeAppenderator;
    }

    @Override
    public Appenderator createOfflineAppenderatorForTask(String taskId, DataSchema schema, AppenderatorConfig config, boolean storeCompactionState, FireDepartmentMetrics metrics, DataSegmentPusher dataSegmentPusher, ObjectMapper objectMapper, IndexIO indexIO, IndexMerger indexMerger) {
        if (this.realtimeAppenderator != null) {
            throw new ISE("A realtime appenderator was already created for this peon's task.", new Object[0]);
        }
        this.batchAppenderator = Appenderators.createOffline(taskId, schema, config, storeCompactionState, metrics, dataSegmentPusher, objectMapper, indexIO, indexMerger);
        return this.batchAppenderator;
    }

    @Override
    public void removeAppenderatorsForTask(String taskId, String dataSource) {
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        if (this.realtimeAppenderator == null) {
            throw new ISE("Was asked for a query runner but realtimeAppenderator was null!", new Object[0]);
        }
        return this.realtimeAppenderator.getQueryRunnerForIntervals(query, intervals);
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        if (this.realtimeAppenderator == null) {
            throw new ISE("Was asked for a query runner but realtimeAppenderator was null!", new Object[0]);
        }
        return this.realtimeAppenderator.getQueryRunnerForSegments(query, specs);
    }

    @Override
    public boolean shouldTaskMakeNodeAnnouncements() {
        return true;
    }

    @Override
    public void shutdown() {
    }
}

