/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.org.apache.druid.data.input.Committer;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.segment.SegmentUtils;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorDriverAddResult;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorDriverMetadata;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorDriverSegmentLockHelper;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentNotWritableException;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentWithState;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class BaseAppenderatorDriver
implements Closeable {
    private static final Logger log = new Logger(BaseAppenderatorDriver.class);
    private final SegmentAllocator segmentAllocator;
    private final UsedSegmentChecker usedSegmentChecker;
    private final DataSegmentKiller dataSegmentKiller;
    protected final Appenderator appenderator;
    protected final Map<String, SegmentsForSequence> segments = new TreeMap<String, SegmentsForSequence>();
    protected final ListeningExecutorService executor;

    BaseAppenderatorDriver(Appenderator appenderator, SegmentAllocator segmentAllocator, UsedSegmentChecker usedSegmentChecker, DataSegmentKiller dataSegmentKiller) {
        this.appenderator = Preconditions.checkNotNull(appenderator, "appenderator");
        this.segmentAllocator = Preconditions.checkNotNull(segmentAllocator, "segmentAllocator");
        this.usedSegmentChecker = Preconditions.checkNotNull(usedSegmentChecker, "usedSegmentChecker");
        this.dataSegmentKiller = Preconditions.checkNotNull(dataSegmentKiller, "dataSegmentKiller");
        this.executor = MoreExecutors.listeningDecorator(Execs.singleThreaded("[" + appenderator.getId() + "]-publish"));
    }

    @VisibleForTesting
    Map<String, SegmentsForSequence> getSegments() {
        return this.segments;
    }

    @Nullable
    public abstract Object startJob(AppenderatorDriverSegmentLockHelper var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentIdWithShardSpec getAppendableSegment(DateTime timestamp, String sequenceName) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            SegmentsForSequence segmentsForSequence = this.segments.get(sequenceName);
            if (segmentsForSequence == null) {
                return null;
            }
            Map.Entry<Long, SegmentsOfInterval> candidateEntry = segmentsForSequence.floor(timestamp.getMillis());
            if (candidateEntry != null) {
                SegmentsOfInterval segmentsOfInterval = candidateEntry.getValue();
                if (segmentsOfInterval.interval.contains((ReadableInstant)timestamp)) {
                    return segmentsOfInterval.appendingSegment == null ? null : segmentsOfInterval.appendingSegment.getSegmentIdentifier();
                }
                return null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentIdWithShardSpec getSegment(InputRow row, String sequenceName, boolean skipSegmentLineageCheck) throws IOException {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            DateTime timestamp = row.getTimestamp();
            SegmentIdWithShardSpec existing = this.getAppendableSegment(timestamp, sequenceName);
            if (existing != null) {
                return existing;
            }
            SegmentsForSequence segmentsForSequence = this.segments.get(sequenceName);
            SegmentIdWithShardSpec newSegment = this.segmentAllocator.allocate(row, sequenceName, segmentsForSequence == null ? null : segmentsForSequence.lastSegmentId, skipSegmentLineageCheck);
            if (newSegment != null) {
                for (SegmentIdWithShardSpec identifier : this.appenderator.getSegments()) {
                    if (!identifier.equals(newSegment)) continue;
                    throw new ISE("WTF?! Allocated segment[%s] which conflicts with existing segment[%s].", newSegment, identifier);
                }
                log.info("New segment[%s] for sequenceName[%s].", newSegment, sequenceName);
                this.addSegment(sequenceName, newSegment);
            } else {
                log.warn("Cannot allocate segment for timestamp[%s], sequenceName[%s].", timestamp, sequenceName);
            }
            return newSegment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSegment(String sequenceName, SegmentIdWithShardSpec identifier) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            this.segments.computeIfAbsent(sequenceName, k -> new SegmentsForSequence()).add(identifier);
        }
    }

    protected AppenderatorDriverAddResult append(InputRow row, String sequenceName, @Nullable Supplier<Committer> committerSupplier, boolean skipSegmentLineageCheck, boolean allowIncrementalPersists) throws IOException {
        Preconditions.checkNotNull(row, "row");
        Preconditions.checkNotNull(sequenceName, "sequenceName");
        SegmentIdWithShardSpec identifier = this.getSegment(row, sequenceName, skipSegmentLineageCheck);
        if (identifier != null) {
            try {
                Appenderator.AppenderatorAddResult result = this.appenderator.add(identifier, row, committerSupplier == null ? null : this.wrapCommitterSupplier(committerSupplier), allowIncrementalPersists);
                return AppenderatorDriverAddResult.ok(identifier, result.getNumRowsInSegment(), this.appenderator.getTotalRowCount(), result.isPersistRequired(), result.getParseException());
            }
            catch (SegmentNotWritableException e) {
                throw new ISE(e, "WTF?! Segment[%s] not writable when it should have been.", identifier);
            }
        }
        return AppenderatorDriverAddResult.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stream<SegmentWithState> getSegmentWithStates(Collection<String> sequenceNames) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            return sequenceNames.stream().map(this.segments::get).filter(Objects::nonNull).flatMap(segmentsForSequence -> ((SegmentsForSequence)segmentsForSequence).intervalToSegmentStates.values().stream()).flatMap(segmentsOfInterval -> segmentsOfInterval.getAllSegments().stream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stream<SegmentWithState> getAppendingSegments(Collection<String> sequenceNames) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            return sequenceNames.stream().map(this.segments::get).filter(Objects::nonNull).flatMap(segmentsForSequence -> ((SegmentsForSequence)segmentsForSequence).intervalToSegmentStates.values().stream()).map(segmentsOfInterval -> ((SegmentsOfInterval)segmentsOfInterval).appendingSegment).filter(Objects::nonNull);
        }
    }

    ListenableFuture<SegmentsAndMetadata> pushInBackground(@Nullable WrappedCommitter wrappedCommitter, Collection<SegmentIdWithShardSpec> segmentIdentifiers, boolean useUniquePath) {
        log.info("Pushing segments in background: [%s]", Joiner.on(", ").join(segmentIdentifiers));
        return Futures.transform(this.appenderator.push(segmentIdentifiers, wrappedCommitter, useUniquePath), segmentsAndMetadata -> {
            Set pushedSegments = segmentsAndMetadata.getSegments().stream().map(SegmentIdWithShardSpec::fromDataSegment).collect(Collectors.toSet());
            if (!pushedSegments.equals(Sets.newHashSet(segmentIdentifiers))) {
                log.warn("Removing segments from deep storage because sanity check failed: %s", SegmentUtils.commaSeparateIdentifiers(segmentsAndMetadata.getSegments()));
                segmentsAndMetadata.getSegments().forEach(this.dataSegmentKiller::killQuietly);
                throw new ISE("WTF?! Pushed different segments than requested. Pushed[%s], requested[%s].", pushedSegments, segmentIdentifiers);
            }
            return segmentsAndMetadata;
        }, (Executor)this.executor);
    }

    ListenableFuture<SegmentsAndMetadata> dropInBackground(SegmentsAndMetadata segmentsAndMetadata) {
        log.debug("Dropping segments: %s", SegmentUtils.commaSeparateIdentifiers(segmentsAndMetadata.getSegments()));
        ListenableFuture dropFuture = Futures.allAsList(segmentsAndMetadata.getSegments().stream().map(segment -> this.appenderator.drop(SegmentIdWithShardSpec.fromDataSegment(segment))).collect(Collectors.toList()));
        return Futures.transform(dropFuture, x -> {
            Object metadata = segmentsAndMetadata.getCommitMetadata();
            return new SegmentsAndMetadata(segmentsAndMetadata.getSegments(), metadata == null ? null : ((AppenderatorDriverMetadata)metadata).getCallerMetadata());
        });
    }

    ListenableFuture<SegmentsAndMetadata> publishInBackground(@Nullable Set<DataSegment> segmentsToBeOverwritten, SegmentsAndMetadata segmentsAndMetadata, TransactionalSegmentPublisher publisher) {
        Object metadata;
        if (segmentsAndMetadata.getSegments().isEmpty()) {
            if (!publisher.supportsEmptyPublish()) {
                log.info("Nothing to publish, skipping publish step.", new Object[0]);
                SettableFuture<SegmentsAndMetadata> retVal = SettableFuture.create();
                retVal.set(segmentsAndMetadata);
                return retVal;
            }
            if (this.appenderator.getTotalRowCount() != 0) {
                throw new ISE("Attempting to publish with empty segment set, but total row count was not 0: [%s].", this.appenderator.getTotalRowCount());
            }
        }
        Object callerMetadata = (metadata = segmentsAndMetadata.getCommitMetadata()) == null ? null : ((AppenderatorDriverMetadata)metadata).getCallerMetadata();
        return this.executor.submit(() -> {
            block6: {
                try {
                    ImmutableSet<DataSegment> ourSegments = ImmutableSet.copyOf(segmentsAndMetadata.getSegments());
                    SegmentPublishResult publishResult = publisher.publishSegments(segmentsToBeOverwritten, ourSegments, callerMetadata);
                    if (publishResult.isSuccess()) {
                        log.info("Published segments with commit metadata [%s]: %s", callerMetadata, SegmentUtils.commaSeparateIdentifiers(segmentsAndMetadata.getSegments()));
                        break block6;
                    }
                    Set<SegmentIdWithShardSpec> segmentsIdentifiers = segmentsAndMetadata.getSegments().stream().map(SegmentIdWithShardSpec::fromDataSegment).collect(Collectors.toSet());
                    Set<DataSegment> activeSegments = this.usedSegmentChecker.findUsedSegments(segmentsIdentifiers);
                    if (activeSegments.equals(ourSegments)) {
                        log.info("Could not publish segments, but checked and found them already published; continuing: %s", SegmentUtils.commaSeparateIdentifiers(ourSegments));
                        boolean physicallyDisjoint = Sets.intersection(activeSegments.stream().map(DataSegment::getLoadSpec).collect(Collectors.toSet()), ourSegments.stream().map(DataSegment::getLoadSpec).collect(Collectors.toSet())).isEmpty();
                        if (physicallyDisjoint) {
                            segmentsAndMetadata.getSegments().forEach(this.dataSegmentKiller::killQuietly);
                        }
                        break block6;
                    }
                    segmentsAndMetadata.getSegments().forEach(this.dataSegmentKiller::killQuietly);
                    if (publishResult.getErrorMsg() != null) {
                        throw new ISE("Failed to publish segments because of [%s]: %s", publishResult.getErrorMsg(), SegmentUtils.commaSeparateIdentifiers(ourSegments));
                    }
                    throw new ISE("Failed to publish segments: %s", SegmentUtils.commaSeparateIdentifiers(ourSegments));
                }
                catch (Exception e) {
                    log.noStackTrace().warn(e, "Failed publish, not removing segments: %s", segmentsAndMetadata.getSegments());
                    Throwables.propagateIfPossible(e);
                    throw new RuntimeException(e);
                }
            }
            return segmentsAndMetadata;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void clear() throws InterruptedException {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            this.segments.clear();
        }
        this.appenderator.clear();
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WrappedCommitter wrapCommitter(Committer committer) {
        ImmutableMap<String, SegmentsForSequence> snapshot;
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            snapshot = ImmutableMap.copyOf(this.segments);
        }
        AppenderatorDriverMetadata wrappedMetadata = new AppenderatorDriverMetadata(ImmutableMap.copyOf(Maps.transformValues(snapshot, input -> ImmutableList.copyOf(((SegmentsForSequence)input).intervalToSegmentStates.values().stream().flatMap(segmentsOfInterval -> segmentsOfInterval.getAllSegments().stream()).collect(Collectors.toList())))), CollectionUtils.mapValues(snapshot, segmentsForSequence -> ((SegmentsForSequence)segmentsForSequence).lastSegmentId), committer.getMetadata());
        return new WrappedCommitter(committer, wrappedMetadata);
    }

    private Supplier<Committer> wrapCommitterSupplier(Supplier<Committer> committerSupplier) {
        return () -> this.wrapCommitter((Committer)committerSupplier.get());
    }

    static class WrappedCommitter
    implements Committer {
        private final Committer delegate;
        private final AppenderatorDriverMetadata metadata;

        WrappedCommitter(Committer delegate, AppenderatorDriverMetadata metadata) {
            this.delegate = delegate;
            this.metadata = metadata;
        }

        @Override
        public Object getMetadata() {
            return this.metadata;
        }

        @Override
        public void run() {
            this.delegate.run();
        }
    }

    static class SegmentsForSequence {
        private final NavigableMap<Long, SegmentsOfInterval> intervalToSegmentStates;
        private String lastSegmentId;

        SegmentsForSequence() {
            this.intervalToSegmentStates = new TreeMap<Long, SegmentsOfInterval>();
        }

        SegmentsForSequence(NavigableMap<Long, SegmentsOfInterval> intervalToSegmentStates, String lastSegmentId) {
            this.intervalToSegmentStates = intervalToSegmentStates;
            this.lastSegmentId = lastSegmentId;
        }

        void add(SegmentIdWithShardSpec identifier) {
            this.intervalToSegmentStates.computeIfAbsent(identifier.getInterval().getStartMillis(), k -> new SegmentsOfInterval(identifier.getInterval())).setAppendingSegment(SegmentWithState.newSegment(identifier));
            this.lastSegmentId = identifier.toString();
        }

        Map.Entry<Long, SegmentsOfInterval> floor(long timestamp) {
            return this.intervalToSegmentStates.floorEntry(timestamp);
        }

        SegmentsOfInterval get(long timestamp) {
            return (SegmentsOfInterval)this.intervalToSegmentStates.get(timestamp);
        }

        Stream<SegmentWithState> allSegmentStateStream() {
            return this.intervalToSegmentStates.values().stream().flatMap(segmentsOfInterval -> segmentsOfInterval.getAllSegments().stream());
        }

        Stream<SegmentsOfInterval> getAllSegmentsOfInterval() {
            return this.intervalToSegmentStates.values().stream();
        }
    }

    static class SegmentsOfInterval {
        private final Interval interval;
        private final List<SegmentWithState> appendFinishedSegments = new ArrayList<SegmentWithState>();
        @Nullable
        private SegmentWithState appendingSegment;

        SegmentsOfInterval(Interval interval) {
            this.interval = interval;
        }

        SegmentsOfInterval(Interval interval, @Nullable SegmentWithState appendingSegment, List<SegmentWithState> appendFinishedSegments) {
            this.interval = interval;
            this.appendingSegment = appendingSegment;
            this.appendFinishedSegments.addAll(appendFinishedSegments);
            if (appendingSegment != null) {
                Preconditions.checkArgument(appendingSegment.getState() == SegmentWithState.SegmentState.APPENDING, "appendingSegment[%s] is not in the APPENDING state", appendingSegment.getSegmentIdentifier());
            }
            if (appendFinishedSegments.stream().anyMatch(segmentWithState -> segmentWithState.getState() == SegmentWithState.SegmentState.APPENDING)) {
                throw new ISE("Some appendFinishedSegments[%s] is in the APPENDING state", appendFinishedSegments);
            }
        }

        void setAppendingSegment(SegmentWithState appendingSegment) {
            Preconditions.checkArgument(appendingSegment.getState() == SegmentWithState.SegmentState.APPENDING, "segment[%s] is not in the APPENDING state", appendingSegment.getSegmentIdentifier());
            Preconditions.checkState(this.appendingSegment == null, "WTF?! Current appendingSegment[%s] is not null. Its state must be changed before setting a new appendingSegment[%s]", this.appendingSegment, appendingSegment);
            this.appendingSegment = appendingSegment;
        }

        void finishAppendingToCurrentActiveSegment(Consumer<SegmentWithState> stateTransitionFn) {
            Preconditions.checkNotNull(this.appendingSegment, "appendingSegment");
            stateTransitionFn.accept(this.appendingSegment);
            this.appendFinishedSegments.add(this.appendingSegment);
            this.appendingSegment = null;
        }

        Interval getInterval() {
            return this.interval;
        }

        SegmentWithState getAppendingSegment() {
            return this.appendingSegment;
        }

        List<SegmentWithState> getAllSegments() {
            ArrayList<SegmentWithState> allSegments = new ArrayList<SegmentWithState>(this.appendFinishedSegments.size() + 1);
            if (this.appendingSegment != null) {
                allSegments.add(this.appendingSegment);
            }
            allSegments.addAll(this.appendFinishedSegments);
            return allSegments;
        }
    }
}

